<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\InformeController;
use App\Http\Controllers\Repuestos\RepuestosController;
use App\Http\Controllers\Usuarios\UserController;
use App\Http\Controllers\Bodegas\BodegasController;
use App\Http\Controllers\Repuestos\CategoriaRepuestosController;
use App\Http\Controllers\Repuestos\MarcasModelosController;
use App\Http\Controllers\Graficos\CablesController;
use GuzzleHttp\Psr7\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Auth::routes();


// Route::get('grafico_cables', [App\Http\Controllers\Graficos\CablesController::class, 'index']);

// Route::get('graficosmateriales', [App\Http\Controllers\Graficos\CablesController::class, 'graficosMateriales']);
// Route::get('grafico_user', [App\Http\Controllers\Graficos\CablesController::class, 'GraficoUser']);



// Route::get('graficosmateriales2', [App\Http\Controllers\Graficos\Cables2Controller::class, 'graficosMateriales']);
// Route::get('grafico_user2', [App\Http\Controllers\Graficos\Cables2Controller::class, 'GraficoUser']);

Route::resource('users', UserController::class);
Route::get('creausuario', [App\Http\Controllers\Usuarios\UserController::class, 'CreaUsuario']);
Route::get('crea_cliente', [App\Http\Controllers\Usuarios\UserController::class, 'creaCliente']);

Route::get('materiales/{bodega_id}', [RepuestosController::class, 'Materiales']);

Route::get('/', [App\Http\Controllers\HomeController::class, 'index']);

Route::get('index', [RepuestosController::class, 'index']);
// Route::get('entrega_materiales', [RepuestosController::class, 'EntregaMateriales']);


Route::get('devolver_materiales', [RepuestosController::class, 'DevolverMaterial']);

// Route::get('materiales_entregados', [RepuestosController::class, 'MaterialesEntregados']);
Route::get('edita_campo_en_tabla', [RepuestosController::class, 'EditaCampoEnTabla']);
Route::post('edita_img', [RepuestosController::class, 'EditaImg']);
Route::get('carga_material', [RepuestosController::class, 'CargaMaterial']);
Route::post('aumento_stock', [RepuestosController::class, 'AumentoStock']); 
Route::post('creamaterial', [RepuestosController::class, 'CreaMaterial']);
Route::get('devolucion_materiales', [RepuestosController::class, 'DevolucionMateriales']);

Route::post('modelos_por_marca', [RepuestosController::class, 'ModelosPorMarca']); 


Route::get('informes', [App\Http\Controllers\InformeController::class, 'index']);


Route::get('reparacion_cables_mina', [App\Http\Controllers\InformeController::class, 'reparacion_cables_mina']);
Route::post('guardasenialetica', [App\Http\Controllers\InformeController::class, 'GuardaSenialetica']);

Route::get('senialetica', [App\Http\Controllers\InformeController::class, 'InformeSenialetica']);
 


Route::get('selectusuario', [App\Http\Controllers\InformeController::class, 'SelectUsuario']);
Route::get('guardachecklistreparacable', [App\Http\Controllers\InformeController::class, 'GuardaChecklistReparaCable']);

Route::post('notify_centinela/{id_informe}', [App\Http\Controllers\InformeController::class, 'NotifyCentinela']);

Route::get('busca_informes', [App\Http\Controllers\BuscaInformesController::class, 'index']);
Route::get('resultado_busca_informes', [App\Http\Controllers\BuscaInformesController::class, 'ResultadoBuscaInformes']);


Route::get('detalle_informe', [App\Http\Controllers\BuscaInformesController::class, 'DetalleInforme']);

Route::resource('bodegas', BodegasController::class);

Route::resource('categoria_repuestos', CategoriaRepuestosController::class);

Route::get('ventas', [RepuestosController::class, 'EntregaMateriales']);
Route::post('ventas', [RepuestosController::class, 'MaterialesEntregados']);

Route::post('cambia_estado_material', [RepuestosController::class, 'CambiaEstadoMaterial']);

Route::resource('marcas_modelos', MarcasModelosController::class);
Route::get('edita_campo_en_tabla_marca_vehiculo', [MarcasModelosController::class, 'EditaCampoEnTablaMarcaVehiculo']);
Route::post('cambia_estado_modelo', [MarcasModelosController::class, 'CambiaEstadoModelo']);
Route::post('crear_nuevo_modelo', [MarcasModelosController::class, 'CrearNuevoModelo']);

Route::get('informe_ventas', [RepuestosController::class, 'InformeVentas']);
Route::post('carga_informe_ventas', [RepuestosController::class, 'CargaInformeVentas']);
Route::post('ver_detalle_venta', [RepuestosController::class, 'VerDetalleVenta']);

Route::get('informe_stock', [RepuestosController::class, 'InformeStock']);
