@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/slim-select/slim-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        
    .cropped {
       width: 100px !important;
        height: 100px !important;
        overflow: hidden;
        position: relative;
        float: left;
    }

    .cropped img {
        position:absolute;
        left: -100%;
        right: -100%;
        top: -100%;
        bottom: -100%;
        margin: auto;
        min-height: 100%;
        min-width: 100%;
    }
    .con_stock_critico{
     //   background-color: #999;
    }
    .elimina_material{
        cursor: pointer;
    }
 
    #datatable-buttons_wrapper > .row:nth-child(2){
        overflow: auto!important;
    }
    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Repuestos @endslot
        @slot('title') Ventas @endslot
    @endcomponent
<div class="row">
    {{-- <div class="col-xl-4">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">RUT de Cliente</h4>
                <div class="row">
                    <div class="col-md-8">                      
                        <input type="text" class="form-control" id="rut_user" value="">  
                    </div>
                    <div class="col-md-4">                      
                        <button class="btn btn-primary d-print-none" 
                            type="submit" 
                            id="busca_user" 
                            onclick="buscaUser()">Buscar</button>      
                    </div>


                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col --> --}}

    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                {{-- <h4 class="card-title">Cliente</h4> --}}
                <div class="row">
                    {{-- <div class="col-md-9">                      
                        <strong>Nombre: </strong><span id="nombre_entrega">&nbsp;</span>
                        <br>
                        <strong>Email: </strong><span id="email_entrega">&nbsp;</span>   

                    </div>       --}}
                    <div class="col-md-3">
                        <button type="button" 
                            class="btn btn-success d-print-none" 
                            id="btn_agrega_material" 
                            data-bs-toggle="modal" 
                            data-bs-target="#modalMAteiales">Mostrar Productos</button>  
                    </div>  
                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col -->

</div>
<form  class="custom-validation" action="/ventas" id="form_informe_cables" method="POST" style="display: none"  >
    @csrf
    {{-- <input type="hidden" name="user_recibe_id" id="user_recibe_id" value="" />      --}}

    <input type="hidden" name="user_entrega_id" id="user_entrega_id" value="{{ Auth::user()->id }}" /> 
    <input type="hidden" name="bodega_id" id="bodega_id" value="">
    
    <div class="row" id="row_carga_material" style="display: none;">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">

                    <div class="py-2">
                        <h5 class="font-size-15">Detalle de Venta</h5>

                        <div class="table-responsive">
                            <table class="table table-nowrap table-centered mb-0">
                                <thead>
                                    <tr>   
                                        <th></th>
                                        <th style="width: 70px;">Código</th>
                                        <th>Producto</th>
                                        <th class="text-end">Stock</th>
                                        <th class="text-end">Valor</th>
                                        <th class="text-end">Cantidad</th>
                                        <th class="text-end" style="width: 120px;">Total</th>
                                    </tr>
                                </thead>
                                <tbody id="detalle-venta">
                                    <tr class="fila-subtotal">
                                        <th scope="row" colspan="6" class="border-0 text-end">Subtotal</th>
                                        <td class="border-0 text-end"><h4 id="subtotal-general" class="m-0">0</h4></td>
                                    </tr>

                                    <tr class="fila-descuento">
                                        <th scope="row" colspan="6" class="border-0 text-end">Descuento</th>
                                        <td class="border-0 text-end">
                                            {{-- <h4 id="descuento-general" class="m-0">0</h4> --}}
                                            <input type="number" 
                                                style="width: 80px;display:inline-block;text-align: right;" 
                                                required 
                                                data-parsley-type="number" 
                                                max="" 
                                                name="descuento" 
                                                value="0" 
                                                class="form-control form-control-sm" 
                                                id="descuento-venta"></input>

                                        </td>
                                    </tr>

                                    <tr class="fila-total">
                                        <th scope="row" colspan="6" class="border-0 text-end">Total</th>
                                        <td class="border-0 text-end"><h4 id="total-general" class="m-0">0</h4></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="d-print-none mt-4">
                            <div class="float-end">
                                <a href="javascript:window.print()" class="btn btn-success waves-effect waves-light me-1"><i class="fa fa-print"></i></a>
                                {{-- <a href="#" class="btn btn-primary w-md waves-effect waves-light">Send</a> --}}
                            </div>
                        </div>
                    </div>


                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>  
    <div class="d-grid gap-2">
        <button class="btn btn-primary d-print-none" id="btn_entrega_material" type="submit" style="display: none;">Finalizar Venta</button>
    </div>       
 
</form>

<div class="modal fade" id="modalMAteiales" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen" role="document" style="width: 90vw; margin: 0 auto;">
        <div class="modal-content">
            <div class="modal-header">
     
            </div>
            <div class="modal-body">
                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Nombre</th>
                                <th class="columna-bodega">Bodega</th>
                                <th>Categoria</th>
                                <th>Marca</th>
                                <th>Modelo</th>
                                {{-- <th>Año</th> --}}
                                <th>Stock</th>
                                <th>Valor</th>
                                {{-- <th>stock critico</th> --}}
                                {{-- <th>Imagen</th> --}}
                                <th>Vender</th>                                           
                            </tr>
                        </thead>


                        <tbody>

                            @if(isset($materiales))
                                @foreach($materiales as $value)
                                    @if($value->stock_critico >= $value->stock)
                                        <tr class="con_stock_critico">
                                    @else
                                        <tr>
                                    @endif
                                    <td>{{ $value->codigo }}</td>
                                    <td>{{$value->nombre}}</td>
                                    <td>{{ !is_null($value->Bodega)? $value->Bodega->nombre : "" }}</td>
                                    <td>{{$value->CategoriaMateriales->nombre}}</td>                                
                                    <td>{{ !is_null($value->Marca)? $value->Marca->nombre : "" }}</td>
                                    <td>{{ !is_null($value->Modelo)? $value->Modelo->nombre : "" }}</td>
                                    {{-- <td>{{ $value->anio }}</td> --}}
                                    <td>{{$value->stock}}</td>
                                    <td>{{$value->valor}}</td>
                                    {{-- <td>{{$value->stock_critico}}</td>   --}}
                                    {{-- <td class="popup-gallery">
                          
                                        <div class="cropped"  id="mini_img_{{$value->id}}"  >
                                            @if($value->imagen)    

                                            <a class="" href="{{URL::asset('/assets/images/materiales/images/' . $value->imagen)}}" title="{{$value->nombre}}">
                                                <div class="img-fluid">
                                                    <img src="{{URL::asset('/assets/images/materiales/thumbnail/' . $value->imagen)}}" alt=""
                                                        class="img-fluid d-block">
                                                </div>
                                            </a>

                                            @else
                                            <img id="form_img_{{$value->id}}_mini"  src="https://via.placeholder.com/50"   />
                                            @endif
                                        </div>
                                    </td> --}}

                                    <td>
                                        <input type="checkbox" 
                                            name="" 
                                            id="{{$value->id}}_material" 
                                            data-id="{{$value->id}}" 
                                            data-nombre-bodega="{{ !is_null($value->Bodega)? $value->Bodega->nombre : "" }}"
                                            class="agrega_material">
                                    </td>
                                </tr>    
                                @endforeach  
                            @endif
 
                        </tbody> 

                    </table>

 
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

{{-- <div class="modal fade show" id="modal_creaUsuario" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12">
                        <div class="alert alert-info alert-dismissible fade show mb-3" role="alert">
                            <i class="uil uil-question-circle d-blosck display-5 mt-1 mb-1 text-info"></i>
                            El Cliente no existe, ¿Desea crearlo?
                        </div>                              
                    </div>
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-danger btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">No</button>
                    </div>
                </div>
            </div>
            <div class="modal-body">
                 <h5 class="modal-title" id="exampleModalLabel">Nuevo Cliente</h5>
                <form id="form_crea_usu"  class="custom-validation" action="javascript:void(0);" >                   
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Nombre: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-name"  name="nombres" required >
                    </div>
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Apellido Paterno: </label>
                        <input type="text" class="form-control campo_validado" id="apellido_paterno"  name="apellido_paterno"  required>
                    </div>
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Apellido Materno: </label>
                        <input type="text" class="form-control campo_validado" id="apellido_materno"  name="apellido_materno" required>
                    </div>

                    <div class="form-group">
                        <label for="recipient-rut" class="col-form-label ">Rut: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-rut"  name="rut" required>
                    </div>
                    <div class="form-group">
                        <label for="recipient-email" class="col-form-label ">Email: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-email" name="email" required>
                    </div>
                    <br>
                    <input type="submit"  class="btn btn-primary" id="guarda_usuario"  value="Enviar" onClick="creaUser()">            
                </form> 
            </div>
            <div class="modal-footer">
               

            </div>
        </div>
    </div>
</div> --}}



@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    
    <script src="{{ URL::asset('/assets/js/pages/form-validation.init.js') }}"></script>
    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->
    <script src="{{ URL::asset('/assets/js/pages/lightbox.init.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/slim-select/slim-select.min.js')}}"></script>
        <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/jquery.Rut.js')}}"></script>
    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>
    

    <script type="text/javascript">

        // function buscaUser(rut){  

        //     var rut_user = $("#rut_user").val();

        //     $.get("/selectusuario?rut_user="+rut_user,function(response){

        //         if( typeof response != 'string'){

        //             cargaResponsable(response);

        //         }else{
        //             $("#modal_creaUsuario").modal('show');
        //             // $("#recipient-rut").val(response);
        //             $("#recipient-rut").val(rut_user);
        //         }

        //     });
            

        // }

        // function cargaResponsable(response){
 
        //     $("#nombre_entrega").text(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
        //     $("#user_recibe_id").val(response[0].id);
        //     // $("#rut_entrega").text(response[0].rut);
        //     $("#email_entrega").text(response[0].email);
        //     // $("#empresa_entrega").text(response[0].empresa.nombre);
        //     $("#form_informe_cables,#btn_agrega_material").show(); 

        //     // mensajeRetorno('Trabajador encontrado', 'success', 6000);  


        // }
        // function creaUser(){

        //     $.get("/crea_cliente",{
        //         nombre : $("#recipient-name").val(),
        //         apellido_materno : $("#apellido_materno").val(), 
        //         apellido_paterno : $("#apellido_paterno").val(), 
        //         rut : $("#recipient-rut").val(), 
        //         email : $("#recipient-email").val(), 
        //         // empresa_id: $("#empresa_id").val()
        //     },
        //     function(response){ 
        //             cargaResponsable(response);
        //             $("#modal_creaUsuario").modal('hide');       
        //     });
        // }


        


        $(function(){

            var materiales = @json($materiales);       
            var success =  @json(Session::get('success')); 
            if(success){
                mensajeRetorno(success, 'success', 6000);  
            }
            $(".select2").select2();
     
            datatableSearch(['text','text','select','select','select', 'select'], []);

            $('#modalMAteiales').on('hidden.bs.modal', function (e) {
               // $('.agrega_material').prop('checked', false); 
            });

            // $('#rut_user').Rut({
            //     format_on: 'keyup'             
            // });

            // $('#recipient-rut').Rut({
            //     format_on: 'keyup'             
            // });


            // Variable global para almacenar el número de checkboxes seleccionados
            let checkboxesSeleccionados = 0;
            let primeraEjecucion = true;
            // Evento 'change' que se dispara cuando cambia un checkbox
            $(document).on('change', '#datatable-buttons .agrega_material', function(event) {
                // Obtener el número actual de checkboxes seleccionados en la página actual
                const checkboxesSeleccionadosEnPagina = $('#datatable-buttons .agrega_material:checked').length;

                if (!$(this).prop('checked')) {
                    checkboxesSeleccionados--; // Restar uno si un checkbox fue deseleccionado
                } else {
                    checkboxesSeleccionados++; // Sumar uno si un checkbox fue seleccionado
                }

                // Establecer el total de checkboxes seleccionados en el atributo 'data' de la tabla
                $('#datatable-buttons').data('checkboxesSeleccionados', checkboxesSeleccionados);

                // Lógica para el primer checkbox seleccionado
                if (checkboxesSeleccionados === 1 && primeraEjecucion) {

                    if(!confirm("Al seleccionar este producto, solo podrá continuar con la venta de productos que se encuentran en: " + $(this).data("nombre-bodega") + ". ¿Desea Continuar?")){
                        checkboxesSeleccionados--; // Restar uno si un checkbox fue deseleccionado
                        $(this).prop("checked", false);
                        return false; //termina la ejecucion de todo y no selecciona nada
                    }

                    console.log('El primer checkbox ha sido seleccionado');
                    $("#form_informe_cables").show(); 

                    primeraEjecucion = false;
                    // Ejecutar cualquier función que necesites al seleccionar el primer checkbox
                    //selecciona y bloquea seleccion de bodega seleccionada
                    $(".columna-bodega")
                        .find("select")
                        .val($(this).data("nombre-bodega"))
                        .trigger("change")
                        .prop("disabled", true);
                }

                // Lógica para cuando no hay checkboxes seleccionados
                if (checkboxesSeleccionados === 0) {
                    alert("No quedan productos seleccionados. Se vuelven a mostrar los productos de todas las bodegas");

                    console.log('No quedan más checkboxes seleccionados');

                    primeraEjecucion = true;
                    // Ejecutar cualquier función que necesites cuando no hay checkboxes seleccionados
                    $(".columna-bodega")
                        .find("select")
                        .val("")
                        .trigger("change")
                        .prop("disabled", false);

                    $("#bodega_id").val("");

                }

                //continua con la logica
                if($(this).prop('checked')){

                    var html = '';
                    $.get("/carga_material",{id : $(this).data('id')}, function(response){

                        // html += '<div class="col-lg-6" id="material_cargado_'+response.id+'"><div class="card">';
                        // html+= '<div class="row g-0 align-items-center"><div class="row" style="text-align: right;""><div class="col-md-12 elimina_material" data-id="'+response.id+'">x</div></div>';
                        // html += '<div class="col-md-2 cropped">';
                        // html += '    <img class="card-img img-fluid"  src="/assets/images/materiales/thumbnail/'+response.imagen+'" alt="Card image" width="100">';
                        // html += '</div>';
                        // html += '<div class="col-md-10">';
                        // html += '    <div class="card-body">';
                        // html += '        <h5 class="card-title">'+response.nombre+'</h5>';
                        // html += '        <input type="hidden"  required data-parsley-type="number" name="materiales['+response.id+'][material]" value="'+response.id+'"></input>'; 
                        // html += '        <input type="number" style="width: 80px;" required data-parsley-type="number" max="'+response.stock+'" name="materiales['+response.id+'][cantidad]" value=""></input>';

                        // html += '        <input type="hidden" style="width: 80px;" value="'+response.nombre+'"  name="materiales['+response.id+'][nom_material]"  ></input>';                                                    

                        // html += '    </div>';
                        // html += '</div>';
                        // html += '</div></div></div>'; 

                        // $("#carga_material").append(html);
                        $("#bodega_id").val(response.bodega_id);
                        
                        var nombreMarca = "";
                        if(response.marca != null){
                            nombreMarca = response.marca.nombre;
                        }

                        var nombreModelo = "";
                        if(response.modelo != null){
                            nombreModelo = response.modelo.nombre;
                        }

                        html += '<tr id="material_cargado_'+response.id+'">'; 
                        html += '    <th scope="row"><div class="col-md-12 elimina_material" data-id="'+response.id+'">x</div></th>'; 
                        html += '    <th scope="row">' + response.codigo + '</th>'; 
                        html += '    <td>'; 
                        html += '        <h5 class="font-size-15 mb-1">' + response.nombre + '</h5>'; 
                        html += '        <input type="hidden" required data-parsley-type="number" name="materiales[' + response.id + '][material]" value="' + response.id + '"></input>'; 
                        html += '        <input type="hidden" value="' + response.nombre + '"  name="materiales[' + response.id + '][nom_material]"  ></input>';                                                    
                        html += '        <ul class="list-inline mb-0">'; 
                        html += '            <li class="list-inline-item">Categoría: <span class="fw-medium">' + response.categoria_materiales.nombre + '</span></li>'; 
                        html += '            <li class="list-inline-item">Marca: <span class="fw-medium">' + nombreMarca + '</span></li>'; 
                        html += '            <li class="list-inline-item">Modelo: <span class="fw-medium">' + nombreModelo + '</span></li>'; 
                        html += '            <li class="list-inline-item">Año: <span class="fw-medium">' + response.anio + '</span></li>'; 
                        html += '        </ul>'; 
                        html += '    </td>'; 
                        html += '    <td class="text-end">' + response.stock + '</td>'; 
                        html += '    <td class="text-end">' + response.valor + '</td>'; 
                        // html += '    <td>1</td>'; 
                        html += '    <td class="text-end"><input type="number" style="width: 80px;display:inline-block;text-align: right;" required data-parsley-type="number" min="1" max="' + response.stock + '" name="materiales[' + response.id + '][cantidad]" value="1" class="cantidad-producto form-control form-control-sm" data-id-repuesto="' + response.id + '" data-valor="' + response.valor + '" id="cantidad_repuesto_' + response.id + '"></input></td>';
                        html += '    <td class="text-end"><span id="total-linea-prod-' + response.id + '" class="total-linea" data-total-linea="' + response.valor + '">' + response.valor + '</span></td>'; 
                        html += '</tr>'; 
                        
                        $("#detalle-venta").prepend(html);
                        actualizarTotalGeneral();

                    });

                    $("#btn_entrega_material,#row_carga_material").show();

                }else{
                    $("#material_cargado_"+$(this).data('id')).remove();
                    if($(".elimina_material").length == 0 ){

                        $("#btn_entrega_material,#row_carga_material").hide();

                    }
                }

            });

            // $(".elimina_material").click(function(){
            $(document).on('click', '#detalle-venta .elimina_material', function(event) {
                $("#"+$(this).data('id')+"_material").prop('checked', false); //quita la seleccion en la tabla de productos
                checkboxesSeleccionados--; // Restar uno si un checkbox fue deseleccionado
                if (checkboxesSeleccionados === 0) {
                    alert("No quedan productos seleccionados. Se vuelven a mostrar los productos de todas las bodegas");

                    console.log('No quedan más checkboxes seleccionados');

                    primeraEjecucion = true;
                    // Ejecutar cualquier función que necesites cuando no hay checkboxes seleccionados
                    $(".columna-bodega")
                        .find("select")
                        .val("")
                        .trigger("change")
                        .prop("disabled", false);
                    
                    $("#bodega_id").val("");
                    
                }

                $("#material_cargado_" + $(this).data('id')).remove(); //quita el div del area de venta

                actualizarTotalGeneral();

                if($(".elimina_material").length == 0 ){
                    //si ya no quedan mas botones de eliminar, se entiende que ya no quedan elementos
                    //por ende, se bloquean
                    $("#btn_entrega_material,#row_carga_material").hide();
                }

            });

            // $('.cantidad-producto').on('input', function() {
            $(document).on('input', '#detalle-venta .cantidad-producto', function(event) {
                let valorInput = parseInt($(this).val(), 10);

                // Si el valor ingresado es negativo, establecerlo como cero
                if (valorInput < 1 || isNaN(valorInput)) {
                    valorInput = 1;
                    $(this).val('1');
                }
                
                // const valorInput = parseInt($(this).val(), 10);
                const dataValor = parseInt($(this).data('valor'), 10);
                const idRepuesto = $(this).data('id-repuesto');
                const resultado = valorInput > 0 ? valorInput * dataValor : 0;

                // Actualizar el div con el resultado
                $('#total-linea-prod-' + idRepuesto).attr("data-total-linea", resultado);
                $('#total-linea-prod-' + idRepuesto).text(resultado);

                actualizarTotalGeneral();
            });

            $("#descuento-venta").on('input', function(event){
                if ($(this).val() === "" || $(this).val() === null) {
                    $(this).val(0); // Establecer el valor a 0 si está vacío
                }

                actualizarTotalGeneral();
            });

            // // Ejemplo de cómo obtener el total de checkboxes seleccionados incluso después de la paginación
            // function obtenerTotalCheckboxesSeleccionados() {
            //     const totalSeleccionados = $('#datatable-buttons').data('checkboxesSeleccionados') || 0;
            //     console.log('Total de checkboxes seleccionados:', totalSeleccionados);
            // }

            // // Llamar a la función para obtener el total de checkboxes seleccionados
            // obtenerTotalCheckboxesSeleccionados();

            function actualizarTotalGeneral() {
                let totalGeneral = 0;
                let descuento = $("#descuento-venta").val();
                let total = 0;

                // Recorrer todas las filas de productos y sumar sus totales
                $('#detalle-venta .total-linea').each(function() {
                    let dataValor = parseInt($(this).attr('data-total-linea'), 10);

                    totalGeneral += dataValor;
                });

                total = totalGeneral - parseInt(descuento, 10);

                // Actualizar el div con el total general
                $('#subtotal-general').text(totalGeneral);

                $("#total-general").text(total);

                $("#descuento-venta").attr("max", totalGeneral);
            }

            $("#form_informe_cables").on('submit', function(){
                //aca debe validar antes de enviar el submit
                //debe validar el stock de los elementos antes de enviar el formulario al servidor
                //esto para evitar que se descuente stock de un producto que puede haber sido vendido en el mismo momento

            });

        });


    </script>
@endsection
