@extends('layouts.master_no_login')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />    

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        
    @media (max-width: 500px) {
        .facet_sidebar {
            border-bottom: solid 1px #000;
            padding-bottom: 10px;
        }
    }

    input[type="text"]:disabled {
      background: #9295a4;
    }
    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Informes @endslot
        @slot('title') Informe diario de reparacion cables mineros @endslot
    @endcomponent
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Ingrese su rut</h4>
                <div class="row">
                    <div class="col-md-8">                      
                        <input type="text" class="form-control" id="rut_user" value="">              
                    </div>
                    <div class="col-md-2">                      
    					<button class="btn btn-primary" type="submit" id="busca_user" onclick="buscaUser()">Buscar</button>      
                    </div>
                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col -->
</div>

<form  class="custom-validation" action="/guardachecklistreparacable" id="form_informe_cables"  method="GET" style="display: none"  >

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Antecedentes del tecnico reparaciones</h4>
                    <div class="row">
                        <div class="col-md-3">                      
                            <span>Nombre: </span><span id="nombre_entrega"></span>         
                        </div>                 
                        <div class="col-md-2">
                            <span>Rut: </span><span id="rut_entrega"></span>   
                        </div>
                        <div class="col-md-3">
                            <span>Empresa: </span><span id="empresa_entrega"></span>   
                        </div>        
                        <div class="col-md-4">
                            <span>Email: </span><span id="email_entrega"></span>   
                        </div>  
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>    
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">REPARACION DE CABLES MINEROS TIPO  SHG - GC</h4>
                    <div class="row">
                        <div class="col-md-4 mt-2">                      
                            <label class="form-label" for="id_ubicacion">Ubicaci&oacute;n</label>
                            <input type="text" class="form-control" id="id_ubicacion" name="ubicacion" required>              
                        </div>                 
                        <div class="col-md-4">
                            <label for="empresa_id" class="col-form-label ">Empresa:</label>
                            <select class="form-control select2s"  required  name="empresa_id" id="empresa_id" style="width: 100%">
                                <option value="">Seleccione</option>
                                @if(isset($empresas))
                                    @foreach($empresas as $value)
                                        <option value="{{$value->id}}">{{$value->nombre}}</option>
                                    @endforeach  
                                @endif
                            </select>  
                        </div>
                        <input type="hidden" name="user_id" id="user_id">
                        <div class="col-md-4 mt-2">
                            <label class="form-label" for="id_num_cable">N° Cable</label>
                            <input data-parsley-type="alphanum"  type="text" class="form-control" id="id_numero_cable" name="numero_cable" required >
                        </div> 
                        <input type="hidden" name="email_entrega" id="email_usu_entrega">     
                        <input type="hidden" name="tecnico[nom_tecnico]" id="nom_tecnico">  
                        <input type="hidden" name="tecnico[rut_tecnico]" id="rut_tecnico">
                        <input type="hidden" name="tecnico[nom_empresa]" id="nom_empresa">  
                        <input type="hidden" name="tecnico[email_tecnico]" id="email_tecnico">       
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>
        <div class="row">
    	<h1>Informacion de ingreso de cable</h1>
    </div>

    <!-- end row -->
    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Caracteristicas del conductor</h4>
                    <div class="row">
                      	<div class="col-md-3">
                            <label class="form-label" for="enchufe">Enchufe</label><br>
     						<input type="checkbox" id="enchufe"  name="enchufe" switch="none" checked  value="1" />
                            <label for="enchufe" data-on-label="Si" data-off-label="No"></label>
                            <div class="invalid-feedback">
                                Campo requerido!
                            </div>                          
                        </div>
	                    <div class="col-md-3">
	                        <label class="form-label" for="id_fabricante">Fabricante</label>
	                        <input type="text" class="form-control" id="id_fabricante" name="fabricante" required> 
	                    </div>
	                    <div class="col-md-3">
	                        <label class="form-label" for="calibre">Calibre</label> 
	                        <input type="text" id="calibre" class="form-control"  name="calibre" required  /> 
	                    </div>
	                    <div class="col-md-3">
	                        <label class="form-label">Falla</label>        
	                        <input type="text" id="falla"  class="form-control" required name="falla" /> 
	                    </div>
	                </div>
                </div>
            </div>
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title"></h4>
                    <div class="row">
	                    <div class="col-md-4">
	                        <label class="form-label">Clase Aislaci&oacute;n</label>
	                        <input type="text" class="form-control" required name="clase_aislacion" />
	                        <div class="invalid-feedback">
	                            Campo requerido!
	                        </div> 
	                    </div>
	                    <div class="col-md-4">
	                        <label class="form-label">Longitud(m)</label> 
	                        <input type="text" id="longitud" class="form-control" required data-parsley-type="number" name="longitud" />               
	                        <div class="invalid-feedback">
	                            Campo requerido!
	                        </div>  
	                    </div>

	                    <div class="col-md-4">
	                        <label class="form-label">Mufas</label> 
	                        <input type="text" class="form-control" required name="mufas" />
	                        <div class="invalid-feedback">
	                            Campo requerido!
	                        </div> 
	                    </div>
	                </div>    
                </div>
            </div>
        </div> <!-- end col -->
    </div>    
    <div class="row">
        <div class="col-xl-6">
            <div class="card">

                <div class="card-body">
                    <!-- <h4 class="card-title mb-4">Medidas de entrada HI - POT, realizadas a cables antes de reparaci&oacute;n</h4> -->
                    <h4 class="card-title mb-4">
                        Medidas de entrada: Medidor de Aislación, realizadas a cables antes de reparaci&oacute;n
                    </h4>
                    <div class="row">
                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f1_chequeo_ingreso">F1</label> 
                                </div>    
                                <div class="col-md-10 text-center">     
                                    <input type="checkbox" id="f1_chequeo_ingreso" switch="none" class="switch_F" data-inputtext="f1_medidas_ingreso"   value="1" checked name="f1_chequeo_ingreso"  />
                                    <label for="f1_chequeo_ingreso" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f1_medidas_ingreso" required name="f1_medidas_ingreso">
                                </div>
                            </div>   
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_f1" id="unidad_medida_f1" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                        <option value="4">Falla</option>
                                    </select> 
                                </div>
                            </div>                             
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f2_chequeo_ingreso">F2</label>
                                </div>    
                                <div class="col-md-10 text-center">     
                                    <input type="checkbox" id="f2_chequeo_ingreso" class="switch_F" data-inputtext="f2_medidas_ingreso"  switch="none" value="1" checked name="f2_chequeo_ingreso"  />
                                    <label for="f2_chequeo_ingreso" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f2_medidas_ingreso" required name="f2_medidas_ingreso">
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_f2" id="unidad_medida_f2" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                        <option value="4">Falla</option>

                                    </select> 
                                </div>
                            </div>                                  
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f3_chequeo_ingreso">F3</label>
                                </div>    
                                <div class="col-md-10 text-center">     
                                    <input type="checkbox" id="f3_chequeo_ingreso" class="switch_F" switch="none" data-inputtext="f3_medidas_reparacion" value="1" checked name="f3_chequeo_ingreso"  />
                                    <label for="f3_chequeo_ingreso"  data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f3_medidas_ingreso" required name="f3_medidas_ingreso">
                                </div>
                            </div>  
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_f3" id="unidad_medida_f3" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                        <option value="4">Falla</option>

                                    </select> 
                                </div>
                            </div>                                
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-7"> 
                                    <label class="form-label" for="hp_chequeo_ingreso">H/P 500v</label>
                                </div>    
                                <div class="col-md-5 text-center">     
                                    <input type="checkbox" id="hp_chequeo_ingreso" switch="none" value="1" class="switch_F" data-inputtext="hp_medidas_ingreso"  checked name="hp_chequeo_ingreso"  />
                                    <label for="hp_chequeo_ingreso" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="hp_medidas_ingreso" required name="hp_medidas_ingreso">
                                </div>
                            </div> 
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_hp" id="unidad_medida_hp" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                        <option value="4">Falla</option>

                                    </select> 
                                </div>
                            </div>                                 
                        </div>                  
             
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Observaci&oacute;n Inspeccion cables antes de reparaci&oacute;n</h4>
                    <div class="row">
 						<div class="mb-3 col-lg-12">
                            <textarea id="observacion_ingreso" name="observacion_ingreso" class="form-control"  height="55"  required></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
    	<h1>Informe del cable de salida</h1>
    </div>
    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Cortes de Metros</h4>
                  	<div class="row">
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label" for="cortes_metros">Cortes de metros</label><br>
         						<input type="checkbox" id="cortes_metros"  name="cortes_metros" switch="none" value="1"  checked />
                                <label for="cortes_metros" data-on-label="Si" data-off-label="No"></label>
                                <div class="invalid-feedback">
                                    Campo requerido!
                                </div>
                            </div>                          
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label" for="cantidad_metros">Cantidad metros</label>
                                <input type="text" class="form-control" id="cantidad_metros" name="cantidad_metros" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label" for="cantidad_mufas">Cantidad Mufas</label>
                                <input type="text" class="form-control" id="cantidad_mufas" name="cantidad_mufas" required>          
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label class="form-label" for="nueva_cantidad_mufas">Nueva Cant. Mufas</label>
                                <input type="text" class="form-control" id="nueva_cantidad_mufas" name="nueva_cantidad_mufas" required>
                                <div class="invalid-feedback">
                                    Campo requerido!
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Observacion Reparaci&oacute;n realizada</h4>
                    <div class="row">
 						<div class="mb-3 col-lg-12">
                            <textarea id="observacion_reparacion" class="form-control"  height="55" name="observacion_reparacion"  required=""></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
   <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Chequeo medicion HI - POT 10 kv x 5Min realizadas</h4>
                    <small>Medidas utilizando:</small>

                    <div class="row mt-4">
                        <div class="col-md-12 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-4"> 
                                    <label class="form-label" for="dispositivo_medida_blf">VLF</label>
                                </div> 
                                <div class="col-md-8">     
                                    <input type="checkbox" 
                                        id="dispositivo_vlf" 
                                        switch="none" 
                                        class="switch_F" 
                                        value="1" 
                                        checked 
                                        name="dispositivo_vlf"  />

                                    <label for="dispositivo_vlf" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                            </div> 

                            <div class="row">
                                <div class="col-md-4"> 
                                    <label class="form-label" for="dispositivo_medidor_aislacion">Medidor de Aislación</label>
                                </div> 
                                <div class="col-md-8">     
                                    <input type="checkbox" 
                                        id="dispositivo_medidor_aislacion" 
                                        switch="none" 
                                        class="switch_F" 
                                        value="1" 
                                        checked 
                                        name="dispositivo_medidor_aislacion"  />

                                    <label for="dispositivo_medidor_aislacion" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                            </div> 


                        </div>
                    </div>

                  	<div class="row mt-4">
                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f1_chequeo_hi_pot">F1</label>
                                </div>    
                                <div class="col-md-10 text-center">     
             						<input type="checkbox" id="f1_chequeo_hi_pot" switch="none" class="switch_F" data-inputtext="f1_medidas_reparacion"   value="1" checked name="f1_chequeo_hi_pot"  />
                                    <label for="f1_chequeo_hi_pot" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f1_medidas_reparacion" required name="f1_medidas_reparacion">
                                </div>
                            </div>  
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_reparacion_f1" id="unidad_medida_reparacion_f1" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                    </select> 
                                </div>
                            </div>                                
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f2_chequeo_hi_pot">F2</label>
                                </div>    
                                <div class="col-md-10 text-center">     
                                    <input type="checkbox" id="f2_chequeo_hi_pot" class="switch_F" data-inputtext="f2_medidas_reparacion"  switch="none" value="1" checked name="f2_chequeo_hi_pot"  />
                                    <label for="f2_chequeo_hi_pot" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f2_medidas_reparacion" required name="f2_medidas_reparacion">
                                </div>
                            </div>   
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_reparacion_f2" id="unidad_medida_reparacion_f2" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                    </select> 
                                </div>
                            </div>                                
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-2"> 
                                    <label class="form-label" for="f3_chequeo_hi_pot">F3</label>
                                </div>    
                                <div class="col-md-10 text-center">     
                                    <input type="checkbox" id="f3_chequeo_hi_pot" class="switch_F" switch="none" data-inputtext="f3_medidas_reparacion" value="1" checked name="f3_chequeo_hi_pot"  />
                                    <label for="f3_chequeo_hi_pot"  data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="f3_medidas_reparacion" required name="f3_medidas_reparacion">
                                </div>
                            </div>  
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_reparacion_f3" id="unidad_medida_reparacion_f3" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                    </select> 
                                </div>
                            </div>                                 
                        </div>

                        <div class="col-md-3 facet_sidebar"> 
                            <div class="row">
                                <div class="col-md-7"> 
                                    <label class="form-label" for="hp_chequeo_hi_pot">H/P 500v</label>
                                </div>    
                                <div class="col-md-5">     
                                    <input type="checkbox" id="hp_chequeo_hi_pot" switch="none" value="1" class="switch_F" data-inputtext="hp_medidas_reparacion"  checked name="hp_chequeo_hi_pot"  />
                                    <label for="hp_chequeo_hi_pot" data-on-label="Si" data-off-label="No"></label>  
                                </div> 
                                <div class="col-md-12">                                  
                                    <input type="text" class="form-control" id="hp_medidas_reparacion" required name="hp_medidas_reparacion">
                                </div>
                            </div>   
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <select class="form-control select2s"  required  name="unidad_medida_reparacion_hp" id="unidad_medida_reparacion_hp" style="width: 100%">
                                        <option value="" disabled selected>Unidad de Medida</option>
                                        <option value="1">MegaOhm</option>
                                        <option value="2">GigaOhm</option>
                                        <option value="3">TeraOhm</option>
                                    </select> 
                                </div>
                            </div>                                
                        </div>                  
             
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6"> 
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Estados de fase</h4>
                    <div class="row">
                        <div class="col-md-4">
                            <label class="form-label" for="continuidad_fase">Continuidad de fase</label><br>
                            <input type="checkbox" id="continuidad_fase" switch="none" value="1" checked  name="continuidad_fase"/>
                            <label for="continuidad_fase" data-on-label="Si" data-off-label="No"></label>
                        </div>                 
                        <div class="col-md-4">
                            <label class="form-label" for="continuidad_hp">Continuidad de H / P respecto a F1</label><br>
                            <input type="checkbox" id="continuidad_hp" switch="none" value="1" checked name="continuidad_hp" />
                            <label for="continuidad_hp" data-on-label="Si" data-off-label="No"></label>
                        </div>
                        <div class="col-md-4">    
                            <a class="image-popup-no-margins"
                                href="{{ URL::asset('/assets/images/hembra_macho.png') }}"
                                title="Secuencia fases enchufe hemba y macho">
                                <img class="img-fluid" alt="" src="{{ URL::asset('/assets/images/hembra_macho.png') }}"
                                    width="145">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row"> 
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Observacion final</h4>
                    <div class="row">
 						<div class="mb-3 col-lg-12">
                            <textarea id="observacion_general_final" class="form-control"  height="55" required="" name="observacion_general_final"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- end row --> 
    <div class="row">    	
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
	                <h4 class="card-title mb-4">Materiales en terreno</h4>
	                <div class="form-row">
	                    <div class="row popup-gallery" id="carga_materiales">
                          
	
		                </div>
	                </div>
                </div>
			</div>
        </div>
    </div><!--end row-->
        
    <button class="btn btn-primary" type="submit">Enviar</button>
</form>

@endsection
@section('script')

    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
  
    <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>


    <script src="{{ URL::asset('/assets/js/jquery.Rut.js')}}"></script>
    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>


    <script type="text/javascript">

    function removeTema(val){

        $(".carga_tema_"+val).remove();
    }


    // function buscaUser(rut){ 
  
    //     var rut_user = $("#rut_user").val();

    //     $.get("selectusuario?material_id=2&rut_user="+rut_user,function(response){

    //         $("#form_informe_cables").hide();

    //         if(response == 'No existe el Usuario'){

    //             alert(response);
    //             return;
    //         }

    //         if( typeof response != 'string'){

    //             if(!response[1].length){

    //                 alert('Trabajador sin materiales');
    //                 return;

    //             }

    //             cargaResponsable(response);

    //         }else{
    //             $("#exampleModal").modal('show');
    //             $("#recipient-rut").val(response);
    //         }

    //     });        

    // }

    function buscaUser(rut){ 
  
        var rut_user = $("#rut_user").val();

        $.get("selectusuario?material_id=1&rut_user="+rut_user,function(response){

            $("#form_informe_cables").hide();

            if(response == 'No existe el Usuario'){

                alert(response);
                return;
            }

            if( typeof response != 'string'){

                if(!response[1].length){

                    alert('Trabajador sin materiales');
                    return;

                }

                var cantidadFinal = 0;
                for(var i in response[1]){
                    var material = response[1][i];

                    cantidadFinal += material["cantidad"];
                }

                console.log("cantidadFinal", cantidadFinal);

                if(cantidadFinal == 0){

                    alert('Trabajador sin materiales');
                    return;

                }
                
                cargaResponsable(response);

            }else{
                $("#exampleModal").modal('show');
                $("#recipient-rut").val(response);
            }

        });        

    }



    

    function cantidadEntregaMaterial(input){

        var newValue = input.val();
        var id = input.data('id');
        if( parseInt(newValue) > parseInt(input.attr('max'))){
            console.log(1);
            input.val('');
            $("#id_material_"+id).text(input.attr('max'));

        }else{

            if(newValue != ''){

                var nuevo_valor = parseInt(input.parent().prev().val()) - parseInt(newValue);
                $("#id_material_"+id).text(nuevo_valor);

            }
            if(newValue == 0 ){
 
                $("#id_material_"+id).text(input.attr('max'));

            }
        }

        if( nuevo_valor < 0 ){

            $("#id_material_"+id).text(input.attr('max'));
            input.val('');

        }

    }

    function cargaResponsable(response){

        $("#user_id").val(response[0].id);
        $("#nombre_entrega").text(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
        $("#rut_entrega").text(response[0].rut);
        $("#email_entrega").text(response[0].email);
        $("#email_usu_entrega").val(response[0].email);
        $("#empresa_entrega").text(response[0].empresa.nombre);

        $("#empresa_id").val(1);

        $("#nom_tecnico").val(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
        $("#rut_tecnico").val(response[0].rut);
        $("#email_tecnico").val(response[0].email);
        $("#nom_empresa").val(response[0].empresa.nombre);
 

        var html = '';
     
        $.each(response[1], function(k, v){

            if(v.cantidad > 0){
                html += '<div class="col-lg-4">';
                html += '    <div class="card" style="border: solid 3px #22252f;">';
                html += '        <div class="row g-0 align-items-center">';
                html += '            <div class="col-md-2">';

                html += '                   <div class="recorte"  id="mini_img_'+v.id+'"  >'; 

                                            if(v.imagen){

                html += '                       <input type="hidden" value="'+v.imagen+'"   name="material['+v.material_id+'][imagen]">';
                html += '                       <a class="" href="/assets/images/materiales/images/'+v.imagen+'"  title="">';
                html += '                           <div class="img-fluid">';
                html += '                               <img src="/assets/images/materiales/thumbnail/'+v.imagen+'" class="img-fluid d-block">';
                html += '                           </div>';
                html += '                       </a>';                                
                                            }else{

                html += '                       <img  src="https://via.placeholder.com/50"   />';
                                            }

                html += '                   </div>';
                html += '            </div>';
                html += '            <div class="col-md-10">';
                html += '                <div class="card-body">';
                html += '                    <h5 class="card-title">'+v.material+'</h5>';
                html += '                    <input type="hidden" value="'+v.material+'"   name="material['+v.material_id+'][nombre]">';
                html += '                    <div class="row g-0 align-items-center">';
                html += '                       <div class=" col-md-4 card-text">Le quedan : <span id="id_material_'+v.material_id+'">'+v.cantidad+'</span></div>';
                html += '                       <div class=" col-md-4 card-text">de : '+v.cantidad+'</div>';
                html += '                       <input type="hidden" value="'+v.cantidad+'">';
                html +='                        <div class=" col-md-4 card-text">';
                html +='                            <input class="material_ocupado form-control" pattern="[0-9]+" type="number" max="'+v.cantidad+'" min="0" data-id="'+v.material_id+'"  required data-parsley-type="number" name="material['+v.material_id+'][cantidad]" >';
                html +='                        </div>';
                html += '                    </div>';
                html += '                </div>';
                html += '                </div>';
                html += '            </div>';
                html += '        </div>';
                html += '    </div>';
                html += '</div>';
            }       

        });

        $("#carga_materiales").html(html);
        $("#form_informe_cables").show();

        $(".material_ocupado").keyup(function(){

            cantidadEntregaMaterial($(this));
         
        });

        $(".material_ocupado").change(function(){

            cantidadEntregaMaterial($(this));
         
        });

        // $("#cortes_metros").change(function(){

        //     if($(this).prop('checked')){

        //         $("#cantidad_metros,#cantidad_mufas,#nueva_cantidad_mufas").attr('disabled',false).attr('required','required');

        //     }else{
 
        //         $("#cantidad_metros,#cantidad_mufas,#nueva_cantidad_mufas").attr('disabled',true).removeAttr('required');
        //     }


        // });


        

    }

    $(document).ready(function(){


        var materialescriticos = @json($materialescriticos);
        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }
        $(".select2").select2();    


        $(".switch_F").change(function(k,v){
            if($(this).prop('checked')){

                $("#"+$(this).data('inputtext')).attr('disabled',false).attr('required','required');

            }else{
 
                $("#"+$(this).data('inputtext')).attr('disabled',true).removeAttr('required');
            }
        });
        
        $('#rut_user').Rut({
            format_on: 'keyup'             
        });


        //controla
        $('#form_informe_cables').on('submit', function(event) {
            // medidas de entrada
            var f1Value = $('#f1_medidas_ingreso').val();
            var f2Value = $('#f2_medidas_ingreso').val();
            var f3Value = $('#f3_medidas_ingreso').val();
            var hpValue = $('#hp_medidas_ingreso').val();

            // Normalizar el separador decimal
            f1Value = f1Value.replace(',', '.');
            f2Value = f2Value.replace(',', '.');
            f3Value = f3Value.replace(',', '.');
            hpValue = hpValue.replace(',', '.');

            // Asignar los valores actualizados de vuelta a los campos de texto
            $('#f1_medidas_ingreso').val(f1Value);
            $('#f2_medidas_ingreso').val(f2Value);
            $('#f3_medidas_ingreso').val(f3Value);
            $('#hp_medidas_ingreso').val(hpValue);

            // medidas de salida
            var f1ValueRep = $('#f1_medidas_reparacion').val();
            var f2ValueRep = $('#f2_medidas_reparacion').val();
            var f3ValueRep = $('#f3_medidas_reparacion').val();
            var hpValueRep = $('#hp_medidas_reparacion').val();

            // Normalizar el separador decimal
            f1ValueRep = f1ValueRep.replace(',', '.');
            f2ValueRep = f2ValueRep.replace(',', '.');
            f3ValueRep = f3ValueRep.replace(',', '.');
            hpValueRep = hpValueRep.replace(',', '.');

            // Asignar los valores actualizados de vuelta a los campos de texto
            $('#f1_medidas_reparacion').val(f1ValueRep);
            $('#f2_medidas_reparacion').val(f2ValueRep);
            $('#f3_medidas_reparacion').val(f3ValueRep);
            $('#hp_medidas_reparacion').val(hpValueRep);
        });

    });

    </script>
@endsection
