@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
 
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />


    <style type="text/css">
        #datatable-buttons tr.child td.child ul.dtr-details li {
            overflow: auto;
        }

        #datatable-buttons tr.child td.child ul.dtr-details li span.dtr-data div.recorte {
            float: none;
        }

        .imagen_carga{
            width: 300px;
        }

        .recorte {
           width: 50px;
            height: 50px;
            overflow: hidden;
            margin: 10px;
            position: relative;
            float: left;
        }

        .recorte img {
            position:absolute;
            left: -100%;
            right: -100%;
            top: -100%;
            bottom: -100%;
            margin: auto;
            min-height: 100%;
            min-width: 100%;
        }
         
        .custom-file-input {
          color: transparent;
          width: 115px;
        }
        .custom-file-input::-webkit-file-upload-button {
          visibility: hidden;
        }
        .custom-file-input::before {
          content: 'Cargar';
          color: black;
          display: inline-block;
          background: -webkit-linear-gradient(top, #f9f9f9, #e3e3e3);
          border: 1px solid #999;
          border-radius: 3px;
          padding: 5px 8px;
          outline: none;
          white-space: nowrap;
          -webkit-user-select: none;
          cursor: pointer;
          text-shadow: 1px 1px #fff;
          font-weight: 700;
          font-size: 10pt;
        }
        .custom-file-input:hover::before {
          border-color: black;
        }
        .custom-file-input:active {
          outline: 0;
        }
        .custom-file-input:active::before {
          background: -webkit-linear-gradient(top, #e3e3e3, #f9f9f9); 
        }
        .valor_stock{

            width: 70px;
            text-align: left;
            margin-right: 9px;
            float: left;
            padding: 3px;
            border: solid 1px #fff
        }

        table.dataTable.nowrap th, table.dataTable.nowrap td{
            white-space:normal!important;
        }

    </style>

@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Inicio @endslot
        @slot('title') Informe de Stock @endslot
    @endcomponent 


    {{-- <div class="modal fade" id="modalAumentoStock" tabindex="-1" aria-labelledby="modalAumentoStock" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="row">       
                        <div class="col-md-12 d-grid gap-2">
                            <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                        </div>
                    </div>
                </div>
                <div class="modal-body">
                    <h5 class="modal-title" id="modalAumentoStock">Material : <span id="id_nom_material"></span> </h5>
    
                    <form method="POST" enctype="multipart/form-data" id="form-aumento-stock" action="/aumento_stock" class="custom-validation" >          
                        <div class="form-group">
                            <input type="hidden" name="bodega_id" value="{{ $bodega_id }}">
                            <input type="hidden" class="form-control" id="material_id" name="material_id">
                            <input type="hidden" class="form-control" id="user_recibe_id" name="user_recibe_id" value="{{ Auth::user()->id }} ">
                        </div>
                        <div class="form-group">
                            <label for="recipient-rut" class="col-form-label ">Cantidad:</label>
                            <input type="text" class="form-control" id="agrega_cantidad" required data-parsley-type="number" name="cantidad">
                            <div class="invalid-feedback">
                                Campo requerido!
                            </div>  
                        </div>
                        <div class="form-group">
                            <label for="id_documento" class="col-form-label ">Documento:</label>

                            <input type='file' onchange="readImage(this)" class="custom-file-input" id=""  accept="image/*" value="Cargar Imagen" name="document" />
                            <img src="" name="img"  width="50">

                        </div>

                        <input type="hidden" name="_token" id="_token" value="{{ csrf_token() }}" />
                        <button type="submit" id="btn-ingresar-material" class="btn btn-primary">Ingresar Material</button>        
                    </form> 
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
    </div>      --}}

    {{-- <div class="modal fade" id="agregaMaterial" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="row">       
                        <div class="col-md-12 d-grid gap-2">
                            <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                        </div>
                    </div>
                </div>
                <div class="modal-body">

                    <h5 class="modal-title">Nuevo Repuesto</h5>
    
                    <form method="POST" enctype="multipart/form-data" id="form_nuevo_material" class="custom-validation" action="/creamaterial" >          

                        <div class="form-group">
                            <label for="categoria_material_id" class="col-form-label ">Categoria:</label>
                            <select class="form-select"  required name="categoria_material_id" id="categoria_material_id">
                                <option value="">Seleccione</option>
                                @foreach ($categorias as $c)
                                    <option value="{{ $c->id }}">{{ $c->nombre }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="categoria_material_id" class="col-form-label ">Marca Vehículo:</label>
                            <select class="form-select"  required name="marca_vehiculo_id" id="marca_vehiculo_id">
                                <option value="">Seleccione</option>
                                @foreach ($marcas as $m)
                                    <option value="{{ $m->id }}">{{ $m->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="recipient-email" class="col-form-label ">Modelo Vehículo:</label>
                            <select class="form-select"  required name="modelo_vehiculo_id" id="modelo_vehiculo_id">
                                <option value="">Seleccione</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="recipient-rut" class="col-form-label ">Año:</label>
                            <input type="text" class="form-control" id="agrega_anio"  required name="anio">
                        </div>

                        <div class="form-group">
                            <label for="nombre_material" class="col-form-label ">Nombre:</label>
                            <input type="text" class="form-control" id="nombre_material" required name="nombre">
                        </div>

                        <div class="form-group">
                            <label for="recipient-rut" class="col-form-label ">Stock:</label>
                            <input type="text" class="form-control" id="agrega_stock"  required name="stock">
                        </div>
                        <div class="form-group">
                            <label for="recipient-email" class="col-form-label ">Stock critico:</label>
                            <input type="text" class="form-control" id="stock_critico"  required name="stock_critico">
                        </div>

                        <div class="form-group">
                            <label for="recipient-email" class="col-form-label ">Valor:</label>
                            <input type="number" class="form-control" id="agrega_valor"  required name="valor">
                        </div>

                        <br>

                        <div class="form-group">
                            <label for="recipient-email" class="col-form-label ">Código de Barra:</label>
                            <input type="text" class="form-control" id="agrega_codigo"  required name="codigo">
                        </div>
                        
                        <br>
                        <div class="form-group">
                            <label for="recipient-email" class="col-form-label ">Imagen:</label>
                            <input type="file" name="image" placeholder="Choose image"  id="image">
                        </div>
                        <br>

                        <input type="hidden" name="_token" id="_token" value="{{ csrf_token() }}" />
                        <input type="hidden" name="bodega_id" value="{{ $bodega_id }}">
                        <input type="hidden" name="tipo_movimiento" id="tipo_movimiento" value="1" />
                        <button type="submit" id="btn-crear-repuesto" class="btn btn-primary">Crear Repuesto</button>        
                    </form>

                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div> --}}


    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">       
                    {{-- <button type="button" class="btn btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#agregaMaterial">Nuevo</button> --}}
                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Código de Barras</th>
                                <th>Nombre</th>
                                <th>Categoria</th>
                                <th class="text-end">Stock</th>
                                <th class="text-end">Stock crítico</th>
                                {{-- <th>Valor</th> --}}
                            </tr> 
                        </thead>
                        <tbody>

                            @if(isset($materiales))
                                @foreach($materiales as $value)
                                @php
                                    $marca_fila = "";

                                    if($value->stock == 0){
                                        $marca_fila = "table-danger";
                                    }
                                @endphp
                                <tr id="tr_{{$value->id}}" class="{{ $marca_fila }}" >
                                    <td>
                                        {{$value->codigo}}
                                    </td>

                                    <td>
                                        {{$value->nombre}}
                                    </td>
                                    <td class="">  
                                        <div class="">
                                            {{$value->CategoriaMateriales->nombre}}
                                        </div>
                                    </td>
                                    <td class="text-end">  
                                        {{$value->stock}}
                                    </td>
                                    <td class="text-end">              
                                        @if($value->stock_critico >= $value->stock) 

                                            <span style="color: red">{{$value->stock_critico}}</span>
                                            
                                            @else
                                            <span>{{$value->stock_critico}}</span>
                                        @endif 

                                    </td>
                                    
                                    {{-- <td>
                                        {{$value->valor}}
                                    </td> --}}
                                    

                                </tr>    
                                @endforeach  
                            @endif
                        </tbody> 


                </div>
            </div>
        </div>
    </div><!--end row-->

@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/pages/form-validation.init.js') }}"></script>
    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->
    <script src="{{ URL::asset('/assets/js/pages/lightbox.init.js') }}"></script>
 
    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>

    <script type="text/javascript">

    // function eligeMaterial(input){

    //     $("#material_id").val($(input).data('id'));
    //     $("#id_nom_material").text($(input).data('nombre'));

    // }
    // function readImage(input, edita_imagen) {
    //     console.log("edita_imagen: ", edita_imagen);

    //     // alert("se ejecuta");
    //     var _URL = window.URL || window.webkitURL;
    //     if (input.files && input.files[0]) {
    //         var reader = new FileReader();
    //         reader.onload = function (e) {

    //            $(input).next().attr('src', e.target.result );
    //        //    $(input).next().next().val( e.target.result );
    //             img = new Image();
    //             var objectUrl = _URL.createObjectURL(input.files[0]);
    //             img.onload = function () {
                 
    //                 // $(input).parent().prev().children().removeAttr('width').removeAttr('height'); // se eliminan atributos 

    //                 // if(this.width < this.height){ // segun sea el caso , para que la imagen se sentre si es apiasada  o no 
    //                 //     $(input).parent().prev().children().attr('src', e.target.result).attr('width','50'); 
    //                 // }else{
    //                 //      $(input).parent().prev().children().attr('src', e.target.result).attr('height','50');
    //                 // }
    //                 // $(input).closest('form').submit();
    //             };
    //              // $(input).parent().prev().children().click();
    //             // Swal.fire({
    //             //     position: 'top-center',
    //             //     icon: 'success',
    //             //     title: 'Editado con éxito',
    //             //     showConfirmButton: true,
    //             //     timer: 31500,
    //             //     html: "<img src='"+e.target.result+"' alt='Google'  width='200' >",
    //             //     customClass: 'class-name',
    //             // }); 
    //          //   $("#modalImagen").modal("show");
    //             img.src = objectUrl;

    //         }
    //         reader.readAsDataURL(input.files[0]);

    //         if(typeof edita_imagen != "undefined" && edita_imagen == "'edita_img'"){
    //             console.log("edita imagen");
    //             $(input).parent().submit();
    //         }
    //     }
    // }

    // function  activoInactivo(input){
    //     $(input).parent().submit();            
    // } 

    // {{-- var CategoriasDesdeVista = @json($categorias); --}}
    $(document).ready(function(){
    //     console.log(CategoriasDesdeVista);

    //     var OpcionesSelectCategorias = CategoriasDesdeVista.map(function(objeto) {
    //         return { value: objeto.id, text: objeto.nombre };
    //     });
        
    //     $('.edita_campo_select').each(function() {
    //         var $a = $(this);
    //         $a.editable({
    //             mode: 'inline',
    //             inputclass: 'form-select form-select-sm',
    //             value: $a.data('pk'), // Establecer el valor por defecto como data-pk
    //             source: OpcionesSelectCategorias,
    //             success: function (response, newValue) {
    //                 var id = $a.data('id');
    //                 var campo = $a.data('campo');
    //                 $a.attr('width', 30);
    //                 $.get('/edita_campo_en_tabla', {val: newValue, id: id, campo: campo}, function(response) {
    //                     mensajeRetorno('Campo editado con éxito', 'success', 6000);
    //                 });
    //             },
    //         });
    //     });

    //     var success =  @json(Session::get('success'));
    //     if(success){
    //         mensajeRetorno(success, 'success', 6000);  
    //     }

    //     $('#user_entrega_id').on('select2:select', function (e) {
    //         var data = e.params.data;
    //     });


        datatableSearch(['text','select','text','text', 'text'],['excel', 'pdf']);

        $(".select2").select2();

        // var tabla = $('#datatable-buttons').DataTable();
        var tabla = $('.data_table_search').DataTable();

        // Cambiar el ancho de la tercera columna a 250 píxeles
        tabla.column(1).nodes().to$().css('width', '500px');
        tabla.columns.adjust().draw();

        // $("#marca_vehiculo_id").on('change', function(e){
        //     var idMarca = $(this).val();
        //     var selectModelos = $('#modelo_vehiculo_id');

        //     selectModelos.empty();

        //     $.ajax({
        //         url: "/modelos_por_marca",
        //         dataType: 'json',
        //         type: 'POST',
        //         data: {'id_marca': idMarca}, 
        //         success: function(result){
        //             // console.log(result);
        //             if(result.error == false){
        //                 // Agregar una opción por cada modelo obtenido
        //                 selectModelos.append('<option value="">Seleccione</option>')
        //                 $.each(result.modelos, function(index, modelo) {
        //                     selectModelos.append('<option value="' + modelo.id + '">' + modelo.nombre + '</option>');
        //                 });
        //             }
        //         },
        //         error: function(error) {
        //             console.error(error);
        //             alert("Ha ocurrido un error a nivel de servidor. Favor notificar a Soporte.");
        //         }
        //     });
            
        // });

        // $("#form-aumento-stock").on('submit', function(){
        //     $("#btn-ingresar-material").prop("disabled", true);
        // });

        // $("#form_nuevo_material").on('submit', function(){
        //     $("#btn-crear-repuesto").prop("disabled", true);
        // });

    });
        

    </script>
@endsection
