@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/slim-select/slim-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        
    .cropped {
       width: 100px !important;
        height: 100px !important;
        overflow: hidden;
        position: relative;
        float: left;
    }

    .cropped img {
        position:absolute;
        left: -100%;
        right: -100%;
        top: -100%;
        bottom: -100%;
        margin: auto;
        min-height: 100%;
        min-width: 100%;
    }
    .con_stock_critico{
     //   background-color: #999;
    }
    .elimina_material{
        cursor: pointer;
    }
 

    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Materiales @endslot
        @slot('title') Entrega de Materiales @endslot
    @endcomponent
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Ingrese rut de trabajador</h4>
                <div class="row">
                    <div class="col-md-8">                      
                        <input type="text" class="form-control" id="rut_user" value="">  
                    </div>
                    <div class="col-md-2">                      
                        <button class="btn btn-primary" type="submit" id="busca_user" onclick="buscaUser()">Buscar trabajador</button>      
                    </div>
                    <div class="col-md-2">                      
                        <button type="button" class="btn btn-success" id="btn_agrega_material" style="display: none;" data-bs-toggle="modal" data-bs-target="#modalMAteiales">Agregar Materiales</button>   
                    </div>


                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col -->
</div>
<form  class="custom-validation" action="/materiales_entregados" id="form_informe_cables"  type="GET" style="display: none"  >

    <input type="hidden" name="user_recibe_id" id="user_recibe_id" value="" />     

    <input type="hidden" name="user_entrega_id" id="user_entrega_id" value="{{ Auth::user()->id }}" /> 
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Usuario a entregar</h4>
                    <div class="row">
                        <div class="col-md-3">                      
                            <span>Nombre: </span><span id="nombre_entrega">&nbsp;</span>
                        </div>                 
                        <div class="col-md-2">
                            <span>Rut: </span><span id="rut_entrega">&nbsp;</span>   
                        </div>
                        <div class="col-md-3">
                            <span>Empresa: </span><span id="empresa_entrega">&nbsp;</span>   
                        </div>        
                        <div class="col-md-4">
                            <span>Email: </span><span id="email_entrega">&nbsp;</span>   
                        </div>  
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>    
 
     <div class="row" id="row_carga_material" style="display: none;">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Materiales a entrega</h4>
                    <div class="row" id="carga_material">
 
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>  
    <div class="d-grid gap-2">
        <button class="btn btn-primary" id="btn_entrega_material" type="submit" style="display: none;">Entregar Materiales</button>
    </div>       
 
</form>

<div class="modal fade" id="modalMAteiales" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
     
            </div>
            <div class="modal-body">
                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>nombre</th>
                                <th>stock</th>
                                <th>stock critico</th>
                                <th>Categoria</th>
                                <th>Imagen</th>
                                <th>Cargar Material</th>                                           
                            </tr>
                        </thead>


                        <tbody>

                            @if(isset($materiales))
                                @foreach($materiales as $value)
                                @if($value->stock_critico >= $value->stock)
                                <tr class="con_stock_critico">
                                @else
                                <tr>
                                @endif
                                
                                    <td>{{$value->nombre}}</td>
                                    <td>{{$value->stock}}</td>
                                    <td>{{$value->stock_critico}}</td>  
                                    <td>{{$value->CategoriaMateriales->nombre}}</td>                                
                                    <td class="popup-gallery">
                          
                                        <div class="cropped"  id="mini_img_{{$value->id}}"  >
                                            @if($value->imagen)    

                                            <a class="" href="{{URL::asset('/assets/images/materiales/images/' . $value->imagen)}}" title="{{$value->nombre}}">
                                                <div class="img-fluid">
                                                    <img src="{{URL::asset('/assets/images/materiales/thumbnail/' . $value->imagen)}}" alt=""
                                                        class="img-fluid d-block">
                                                </div>
                                            </a>

                                            @else
                                            <img id="form_img_{{$value->id}}_mini"  src="https://via.placeholder.com/50"   />
                                            @endif
                                        </div>
                                    </td>

                                    <td>
                                        <input type="checkbox" name="" id="{{$value->id}}_material" data-id="{{$value->id}}" class="agrega_material">
                                    </td>
                                </tr>    
                                @endforeach  
                            @endif
 
                        </tbody> 

                    </table>

 
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade show" id="modal_creaUsuario" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12">
                        <div class="alert alert-info alert-dismissible fade show mb-3" role="alert">
                            <i class="uil uil-question-circle d-blosck display-5 mt-1 mb-1 text-info"></i>
                            El Trabajador no existe , ¿Deseas crearlo?
                        </div>                              
                    </div>
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">No</button>
                    </div>
                </div>
            </div>
            <div class="modal-body">
                 <h5 class="modal-title" id="exampleModalLabel">Nuevo Trabajador</h5>
                <form id="form_crea_usu"  class="custom-validation" action="javascript:void(0);" >                   
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Nombres: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-name"  name="nombres" required >
                    </div>
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Apellido Paterno: </label>
                        <input type="text" class="form-control campo_validado" id="apellido_paterno"  name="apellido_paterno"  required>
                    </div>
                    <div class="form-group">
                        <label for="recipient-name" class="col-form-label" >Apellido Materno: </label>
                        <input type="text" class="form-control campo_validado" id="apellido_materno"  name="apellido_materno" required>
                    </div>

                    <div class="form-group">
                        <label for="recipient-rut" class="col-form-label ">Rut: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-rut"  name="rut" required>
                    </div>
                    <div class="form-group">
                        <label for="recipient-email" class="col-form-label ">Email: </label>
                        <input type="text" class="form-control campo_validado" id="recipient-email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label for="recipient-email" class="col-form-label ">Empresa: </label>
                        <select class="form-control" name="empresa_id" id="empresa_id" required>
                            <option value="">Seleccione</option>
                            @if(isset($empresas))
                                @foreach($empresas as $value)
                                    <option value="{{$value->id}}">{{$value->nombre}}</option>
                                @endforeach  
                            @endif
                        </select>
                    </div> 
                    <br>
                    <input type="submit"  class="btn btn-primary" id="guarda_usuario"  value="Enviar" onClick="creaUser()">            
                </form> 
            </div>
            <div class="modal-footer">
               

            </div>
        </div>
    </div>
</div>



@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    
    <script src="{{ URL::asset('/assets/js/pages/form-validation.init.js') }}"></script>
    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->
    <script src="{{ URL::asset('/assets/js/pages/lightbox.init.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/slim-select/slim-select.min.js')}}"></script>
        <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/jquery.Rut.js')}}"></script>
    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>
    

    <script type="text/javascript">

        function buscaUser(rut){  

            var rut_user = $("#rut_user").val();

            $.get("selectusuario?rut_user="+rut_user,function(response){

                if( typeof response != 'string'){

                    cargaResponsable(response);

                }else{
                    $("#modal_creaUsuario").modal('show');
                    $("#recipient-rut").val(response);
                }

            });
            

        }

        function cargaResponsable(response){
 
            $("#nombre_entrega").text(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
            $("#user_recibe_id").val(response[0].id);
            $("#rut_entrega").text(response[0].rut);
            $("#email_entrega").text(response[0].email);
            $("#empresa_entrega").text(response[0].empresa.nombre);
            $("#form_informe_cables,#btn_agrega_material").show(); 

            mensajeRetorno('Trabajador encontrado', 'success', 6000);  


        }
        function creaUser(){

            $.get("creausuario",{nombre : $("#recipient-name").val(),apellido_materno : $("#apellido_materno").val(), apellido_paterno : $("#apellido_paterno").val(), rut : $("#recipient-rut").val(), email : $("#recipient-email").val(), empresa_id: $("#empresa_id").val()},

                function(response){ 
                    cargaResponsable(response);
                    $("#modal_creaUsuario").modal('hide');       
                });
        }


        $(".agrega_material").click(function(){

            if($(this).prop('checked')){

                var html = '';
                $.get("carga_material",{id : $(this).data('id')}, function(response){

                    html += '<div class="col-lg-6" id="material_cargado_'+response.id+'"><div class="card">';
                    html+= '<div class="row g-0 align-items-center"><div class="row" style="text-align: right;""><div class="col-md-12 elimina_material" data-id="'+response.id+'">x</div></div>';
                    html += '<div class="col-md-2 cropped">';
                    html += '    <img class="card-img img-fluid"  src="/assets/images/materiales/thumbnail/'+response.imagen+'" alt="Card image" width="100">';
                    html += '</div>';
                    html += '<div class="col-md-10">';
                    html += '    <div class="card-body">';
                    html += '        <h5 class="card-title">'+response.nombre+'</h5>';
                    html += '        <input type="hidden"  required data-parsley-type="number" name="materiales['+response.id+'][material]" value="'+response.id+'"></input>'; 
                    html += '        <input type="number" style="width: 80px;" required data-parsley-type="number" max="'+response.stock+'" name="materiales['+response.id+'][cantidad]" value=""></input>';

                   html += '        <input type="hidden" style="width: 80px;" value="'+response.nombre+'"  name="materiales['+response.id+'][nom_material]"  ></input>';                                                    

                    html += '    </div>';
                    html += '</div>';
                    html += '</div></div></div>'; 

                    $("#carga_material").append(html);

                    $(".elimina_material").click(function(){

                        $("#material_cargado_"+$(this).data('id')).remove();
                        $("#"+$(this).data('id')+"_material").prop('checked', false);

                        if($(".elimina_material").length == 0 ){

                            $("#btn_entrega_material,#row_carga_material").hide();
                        }

                    });
           
                });

                $("#btn_entrega_material,#row_carga_material").show();

            }else{

                $("#material_cargado_"+$(this).data('id')).remove();
                if($(".elimina_material").length == 0 ){

                    $("#btn_entrega_material,#row_carga_material").hide();

                }


            }


        });


        $(function(){

            var materiales = @json($materiales);       
            var success =  @json(Session::get('success')); 
            if(success){
                mensajeRetorno(success, 'success', 6000);  
            }
            $(".select2").select2();
     
            datatableSearch(['text','text','text','select'],[]);
            $('#modalMAteiales').on('hidden.bs.modal', function (e) {
               // $('.agrega_material').prop('checked', false); 
            });
            $('#rut_user').Rut({
                format_on: 'keyup'             
            });

        });


    </script>
@endsection
