@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />


    <style type="text/css"> 

        button:disabled {
            background: #9295a4!important;
        }
    </style>

@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Forms @endslot
        @slot('title') Categoría de Materiales @endslot
    @endcomponent
  

 


<div class="modal fade" id="creaCategoria" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                    </div>
                </div>
            </div>
 
               
            <div class="modal-body">
                <form  id="form_edita_crea" class="custom-validation" action="{{ route('categoria_repuestos.store') }}" method="POST">
                 @csrf
      
                 <input type="hidden" id="edita_categoria_repuesto_id" name="categoria_repuesto_id" value="">
                
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                         
                            <label class="form-label" for="id_name">Nombre Completo</label>
                            <input type="text" class="form-control" id="id_name" required name="nombre">
      
                        </div>
                    </div>
                </div>
            </div>
   
                <input type="submit" class="btn btn-primary" id="guarda_categoria_repuesto" value="Enviar"> 
      
        </form>
 
        </div>
    </div>
</div>

    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">

                    <button type="button" 
                        id="crea" 
                        class="btn btn-primary waves-effect waves-light" 
                        data-bs-toggle="modal" 
                        data-bs-target="#creaCategoria">Nuevo</button>

                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Editar</th>                                 
                                <th>Habilitado</th>  

                            </tr>
                        </thead>


                        <tbody>

                            @if(isset($categorias))
                                @foreach($categorias as $c)
                                <tr>
                                    <td>
                                        <span id="name_{{$c->id}}">{{$c->nombre}}</span>
                                    </td>
                                    <td>
                                        <button 
                                            class="btn btn-primary editar"  
                                            data-id="{{$c->id}}" 
                                            @if(!$c->estado) disabled @endif >

                                                Editar
                                        </button> 
                                    </td>
                                    <td>
                                        <form id="form_estado_{{ $c->id }}" action="{{ route('categoria_repuestos.destroy',$c->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            
                                            <input type="hidden" name="categoria_repuesto_id" value="{{ $c->id }}">

                                            <input 
                                                onchange="activoInactivo(this)" 
                                                data-id-form="form_estado_{{ $c->id }}" 
                                                type="checkbox" 
                                                id="estado_{{$c->id}}" 
                                                name="activo_inactivo" 
                                                switch="success" 
                                                @if($c->estado) checked="" @endif 
                                                value="1" 
                                                data-parsley-multiple="enchufe" >

                                            <label 
                                                for="estado_{{$c->id}}" 
                                                data-on-label="si" 
                                                data-off-label="No"></label> 
                                        </form> 
                                    </td>


                                </tr>    
                                @endforeach  
                            @endif
 
                        </tbody> 


                </div>
            </div>
        </div>
    </div><!--end row-->




@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->

    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>


        <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>
    
    <script src="{{ URL::asset('/assets/libs/slim-select/slim-select.min.js') }}"></script>
    <link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
    <script>
        
    </script>


    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>




    <script type="text/javascript">

    function  activoInactivo(input){
        $(input).parent().submit();            
    }

    $(document).ready(function(){ 

        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }

        $('#creaCategoria').on('hidden.bs.modal', function (e) {
            $(".parsley-errors-list").remove();
            $("#form_edita_crea input,select").removeClass("parsley-error");
            $("#form_edita_crea")[0].reset();
        })


        $(".editar").click(function(){
            var full_nombre = $("#name_"+$(this).data("id")).text().trim();

            $("#id_name").val( full_nombre );

            $("#creaCategoria").modal("show");
     
            $("#form_edita_crea").attr("action","/categoria_repuestos/"+$(this).data('id'));
            $("#form_edita_crea").append("<input name='_method' type='hidden' value='PUT' id='put'>");
     
            $("#edita_categoria_repuesto_id").val($(this).data('id'));
        });

        $("#crea").click(function(){

            $("#form #put").remove();
            $("#form").attr("action","/categoria_repuestos");  
        });

        datatableSearch(['text'],['excel', 'pdf']);

        $(".select2").select2(); 
        

    });
        



    </script>
@endsection

@section('css')
<link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
@endsection

