@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />


    <style type="text/css"> 

        button:disabled {
            background: #9295a4!important;
        }
    </style>

@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Forms @endslot
        @slot('title') Bodegas @endslot
    @endcomponent
  

 


<div class="modal fade" id="creaBodega" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                    </div>
                </div>
            </div>
 
               
            <div class="modal-body">
                <form  id="form_edita_crea" class="custom-validation" action="{{ route('bodegas.store') }}" method="POST">
                 @csrf
      
                 <input type="hidden" id="edita_bodega_id" name="bodega_id" value="">
                
                <div class="container-fluid">
                    <div class="row">
                        {{-- <div class="col-md-6">
 
                            <label class="form-label" for="id_rut">Rut</label>
                            <input type="text" class="form-control" id="id_rut" required name="rut">
                
                        </div> --}}
                        <div class="col-md-12">
                         
                            <label class="form-label" for="id_name">Nombre Completo</label>
                            <input type="text" class="form-control" id="id_name" required name="nombre">
      
                        </div>
                    </div>
                    {{-- <div class="row">
                        <div class="col-md-6">
 
                            <label class="form-label" for="apellido_paterno">Apellido paterno</label>
                            <input type="text" class="form-control" id="apellido_paterno" required name="apellido_paterno">
                
                        </div>
                        <div class="col-md-6">
                         
                            <label class="form-label" for="apellido_materno">Apellido materno</label>
                            <input type="text" class="form-control" id="apellido_materno" required name="apellido_materno">
      
                        </div>
                    </div> --}}
                    {{-- <div class="row">
                        <div class="col-md-6">
                  
                            <label class="form-label" for="id_email">E-Mail <small>(Será para iniciar sesión)</small>
                            </label>
                            <input type="text" class="form-control" id="id_email" required name="email">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="id_password">Contraseña</label>
                            <input type="text" class="form-control" id="id_password" required name="password">
                        </div>
                    </div> --}}
                    {{-- <div class="row">
                        <div class="col-md-6">
                            <label class="form-label" for="empresa_id">Empresa</label>
                            <select id="empresa_id" name="empresa_id"  required  class="form-select">
                                <option value="">Seleccione</option>
                                @if(isset($empresas)) @foreach($empresas as $empresa) 
                                <option value="{{$empresa->id}}">{{$empresa->nombre}}</option>
                                @endforeach @endif
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label" for="rol_id">Rol</label>
                            <select id="rol_id" required  class="form-select" name="rol_id">
                                <option value="">Seleccione</option>
                                @foreach($roles as $rol) 
                                <option value="{{$rol->id}}">{{ $rol->nombre }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div> --}}
                    {{-- <div class="row mt-1">
                        <div class="col-md-6">
                            <label class="form-label" for="multiple">Notificación por Email</label>
                            <select id="multiple" name="id_categoria[]" multiple>
                                    @foreach($categoria_materiales as $cat_mat)                                                      
                                        <option value="{{$cat_mat->id}}">{{$cat_mat->nombre}}</option>
                                    @endforeach 
                            </select>
                        </div>
                    </div> --}}
                </div>
            </div>
   
                <input type="submit" class="btn btn-primary" id="guarda_bodega" value="Enviar"> 
      
        </form>
 
        </div>
    </div>
</div>

    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">

                    <button type="button" 
                        id="crea" 
                        class="btn btn-primary waves-effect waves-light" 
                        data-bs-toggle="modal" 
                        data-bs-target="#creaBodega">Nuevo</button>

                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                {{-- <th>Rut</th> --}}
                                {{-- <th>Rol</th>  --}}
                                {{-- <th>Empresa</th>  --}}
                                {{-- <th>Lista Mandante</th> --}}
                                <th>Editar</th>                                 
                                <th>Habilitado</th>  

                            </tr>
                        </thead>


                        <tbody>

                            @if(isset($bodegas))
                                @foreach($bodegas as $b)
                                <tr>
                                    <td>
                                        <span id="name_{{$b->id}}">{{$b->nombre}}</span>
                                    </td>
                                    {{-- <td class="td_rut">  
                                        <span class="valor_rut" id="rut_{{$user->id}}">{{$user->rut}}</span>
                                    </td> --}}
                                    {{-- <td>                                        
                                        @if(isset($user->Roles[0]['nombre']))
                                            <span>{{ $user->Roles[0]['nombre'] }}</span>
                                            <span id="id_rol_{{$user->id}}" style="display: none">{{ $user->Roles[0]['id'] }}</span> 
                                        @endif
                                    </td> --}}
                                    {{-- <td>                                        
                                        @if(isset($user->Empresa['nombre']))
                                            <span>{{ $user->Empresa['nombre'] }}</span>
                                            <span id="id_empresa_{{$user->id}}" style="display: none">{{ $user->Empresa['id'] }}</span> 
                                        @endif
                                    </td> --}}
                                    {{-- <td>
                                        @if(!is_null($user->notificaciones()) && $user->notificaciones()->count() > 0)
                                            <span>Si</span>
                                        @else
                                            <span>No</span>
                                        @endif
                                    </td> --}}
                                    <td>
                                        <button 
                                            class="btn btn-primary editar"  
                                            data-id="{{$b->id}}" 
                                            {{-- data-rol="{{ $user->roles()->select('id')->get()[0]->id }}"   --}}
                                            {{-- data-email="{{$user->email}}" --}}
                                            {{-- data-notificacion={{$user->notificaciones()->pluck('id_categoria_material')}}   --}}
                                            @if(!$b->estado) disabled @endif >

                                                Editar
                                        </button> 
                                    </td>
                                    <td>
                                        <form id="form_estado_{{ $b->id }}" action="{{ route('bodegas.destroy',$b->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            
                                            <input type="hidden" name="bodega_id" value="{{ $b->id }}">

                                            <input 
                                                onchange="activoInactivo(this)" 
                                                data-id-form="form_estado_{{ $b->id }}" 
                                                type="checkbox" 
                                                id="estado_{{$b->id}}" 
                                                name="activo_inactivo" 
                                                switch="success" 
                                                @if($b->estado) checked="" @endif 
                                                value="1" 
                                                data-parsley-multiple="enchufe" >

                                            <label 
                                                for="estado_{{$b->id}}" 
                                                data-on-label="si" 
                                                data-off-label="No"></label> 
                                        </form> 
                                    </td>


                                </tr>    
                                @endforeach  
                            @endif
 
                        </tbody> 


                </div>
            </div>
        </div>
    </div><!--end row-->




@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->

    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>


        <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>
    
    <script src="{{ URL::asset('/assets/libs/slim-select/slim-select.min.js') }}"></script>
    <link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
    <script>
        
    </script>


    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>




    <script type="text/javascript">

    function  activoInactivo(input){
        $(input).parent().submit();            
    }

    $(document).ready(function(){ 
        // var selectNotificaciones = new SlimSelect({
        //     select: '#multiple',
        //     placeholder: 'Seleccione Categoria a Notificar'
        // });

        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }

        $('#creaBodega').on('hidden.bs.modal', function (e) {
            $(".parsley-errors-list").remove();
            $("#form_edita_crea input,select").removeClass("parsley-error");
            $("#form_edita_crea")[0].reset();
        })


        $(".editar").click(function(){
            var full_nombre = $("#name_"+$(this).data("id")).text().trim();
            // var ar_nombre = full_nombre.split(' ');

            // if( ar_nombre.length == 3){

            //     var nombre = ar_nombre[0];
            //     var ape_pater = ar_nombre[1];
            //     var ape_mater = ar_nombre[2];              

            // }else{

            //     var nombre = ar_nombre[0] + ' ' + ar_nombre[1];
            //     var ape_pater = ar_nombre[2];
            //     var ape_mater = ar_nombre[3]; 

            // }
            // $("#id_rut").val($("#rut_"+$(this).data("id")).text());
            $("#id_name").val( full_nombre );
            // $("#apellido_paterno").val( ape_pater );
            // $("#apellido_materno").val( ape_mater );

            // $("#empresa_id").val($("#id_empresa_"+$(this).data("id")).text());
            // $("#rol_id").val($(this).data("rol"));
            // $("#id_email").val($(this).data('email'));

            // selectNotificaciones.set($(this).data('notificacion'));

            $("#creaBodega").modal("show");
     
            $("#form_edita_crea").attr("action","/bodegas/"+$(this).data('id'));
            $("#form_edita_crea").append("<input name='_method' type='hidden' value='PUT' id='put'>");
            // $("#id_password").removeAttr("required");
     
            $("#edita_bodega_id").val($(this).data('id'));
        });

        $("#crea").click(function(){

            $("#form #put").remove();
            $("#form").attr("action","/bodegas");  
            // $("#id_password").attr("required","required");
        });

        // datatableSearch(['text','text','select'],['excel', 'pdf']);
        datatableSearch(['text'],['excel', 'pdf']);

        $(".select2").select2(); 
        

    });
        



    </script>
@endsection

@section('css')
<link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
@endsection

