<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaterialesEntregadosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('materiales_entregados')){

            Schema::create('materiales_entregados', function (Blueprint $table) {
                $table->id();
                $table->boolean('estado')->default(true);

                $table->integer('cantidad');

                $table->unsignedBigInteger('material_id');
                $table->foreign('material_id')->references('id')->on('materiales');

                $table->unsignedBigInteger('user_entrega_id');
                $table->foreign('user_entrega_id')->references('id')->on('users');

                $table->unsignedBigInteger('user_recibe_id');
                $table->foreign('user_recibe_id')->references('id')->on('users');

                $table->timestamps();
                $table->softDeletes();
                
            });

        }else{
            echo "Ya existe la tabla materiales_entregados\n";
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('materiales_entregados');
    }
}
