<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaterialesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('materiales', function (Blueprint $table) {
            $table->id();
            $table->string('nombre', 50);
            $table->integer('tipo_movimiento');
            $table->integer('stock');                
            $table->integer('stock_critico');
            $table->string('imagen', 50)->nullable();
            $table->boolean('estado')->default(true);
            $table->unsignedBigInteger('categoria_material_id');
            $table->foreign('categoria_material_id')->references('id')->on('categoria_materiales');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('materiales');
    }
}
