<?php

namespace App\Models\Usuarios;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nombre',
        'apellido_paterno',
        'apellido_materno',        
        'email',
        'rut',
        'password',
        'empresa_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function Empresa(){
        return $this->belongsTo('App\Models\Empresa');
    }
    public function Roles(){
        return $this->belongsToMany(Rol::class);
    }

    public function RolesSupervisor(){
        return $this->belongsToMany(Rol::class)->where('id','=','3');
    }    

    public function MaterialesEntregados(){
        return $this->hasMany(MaterialesEntregados::class, 'user_recibe_id', 'id');
    }

    public function Notificaciones(){
        return $this->hasMany('App\Models\UserNotificacion', 'id_user', 'id');
    }  


    public function getFullNombreAttribute(){

        return "{$this->nombre } {$this->apellido_paterno} {$this->apellido_materno}";

    }

}
