<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Materiales extends Model {
    protected $fillable = [
        'id',
        'nombre',
        'stock',
        'stock_critico',
        'tipo_movimiento',
        'categoria_material_id',
        'imagen',
        'bodega_id',
        'marca_vehiculo_id',
        'modelo_vehiculo_id',
        'anio',
        'valor',
        'codigo'
    ];
    
    protected $table = 'materiales';

    public function CategoriaMateriales(){
        return $this->hasOne(CategoriaMateriales::class, 'id', 'categoria_material_id');
    }

    public function Marca(){
        return $this->hasOne(MarcaVehiculo::class, 'id', 'marca_vehiculo_id');
    }

    public function Modelo(){
        return $this->hasOne(ModeloVehiculo::class, 'id', 'modelo_vehiculo_id');
    }

    public function Bodega(){
        return $this->hasOne(Bodega::class, 'id', 'bodega_id');
    }
 
}