<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class  InformeCable extends Model {
    protected $fillable = [
        'id',
        'ubicacion',
        'empresa_id',
        'user_id',
        'numero_cable',
        'enchufe',
        'fabricante',
        'calibre',
        'falla',
        'clase_aislacion',
        'longitud',
        'mufas',
        'f1_medidas_ingreso',
        'unidad_medida_f1',
        'f2_medidas_ingreso',
        'unidad_medida_f2',
        'f3_medidas_ingreso',
        'unidad_medida_f3',
        'hp_medidas_ingreso',
        'unidad_medida_hp',
        'observacion_ingreso',
        'cortes_metros',
        'cantidad_metros',
        'cantidad_mufas',
        'nueva_cantidad_mufas',
        'observacion_reparacion',
        'dispositivo_vlf',
        'dispositivo_medidor_aislacion',
        'f1_medidas_reparacion',
        'unidad_medida_reparacion_f1',
        'f2_medidas_reparacion',
        'unidad_medida_reparacion_f2',
        'f3_medidas_reparacion',
        'unidad_medida_reparacion_f3',
        'hp_medidas_reparacion',
        'unidad_medida_reparacion_hp',
        'observacion_general_final',
        'continuidad_fase',
        'continuidad_hp',      
    ];


    protected $table = 'informe_cables';

    public function MaterialInformeCable(){
        return $this->hasMany(MaterialInformeCable::class, 'informe_cable_id', 'id');
    }
    public function User(){
        return $this->hasOne('App\Models\Usuarios\User', 'id', 'user_id');
    }
    public function Empresa(){
        return $this->hasOne(Empresa::class, 'id', 'empresa_id');
    }

}