<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EnvioEmailInforme extends Mailable
{
    use Queueable, SerializesModels;

    public $excelData;  
    public $customMessage;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($excelData, $customMessage)
    {
        $this->excelData = $excelData;
        $this->customMessage = $customMessage;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.envio_email_informe')
                    ->with(['customMessage' => $this->customMessage])
                    ->attachData($this->excelData, 'data.xlsx', [
                        'mime' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    ]);
    }
}
