<?php

namespace App\Http\Controllers\Usuarios;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;

use App\Models\Usuarios\Rol;
use App\Models\Usuarios\RolUser;
use App\Models\Empresa;
use App\Models\Usuarios\User;
use App\Models\CategoriaMateriales;
use App\Models\UserNotificacion;

use App\Http\Traits\MetodosGlobales;

class UserController extends Controller
{
    
    use MetodosGlobales;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $user = User::with('Empresa')
            ->with('Roles')
            ->with('Notificaciones')
            ->where(function ($query) {
                $query->whereHas('Roles', function ($q) {
                    $q->where('rol_id', 1); // Filtra los usuarios con rol igual a 1
                })
                ->orWhereDoesntHave('Roles'); // Filtra los usuarios sin roles
            })
            ->orderBy('nombre')
            ->get();

        // dd($user);
        $roles = Rol::orderBy("nombre")->get();

        $empresas = Empresa::where("estado", "=", "1")->orderBy("nombre")->get();

        $categoria_materiales = CategoriaMateriales::where('estado',1)->get();

        $datos = [

            "roles" => $roles,
            "empresas" => $empresas,
            "usuarios" => $user,
            "categoria_materiales" =>$categoria_materiales,

        ];

        return view('usuarios.index', $datos);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('turnos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $request->validate([
            'nombre' => 'required',
            'email' => 'required',
        ]);
 
        $email = $request->input("email"); 
        $clave = $request->input("password"); 
        $this->enviaEmail('mails.nuevo_usuario_email', ['email'=> $email ,'clave' => $clave ] , $request->input("email") , 'Datos Nuevo Usuario Gestion Jc', '');
 
        $request->request->add(['password' => Hash::make($request->input("password"))]); 
        $nuevo_usuario = User::create($request->all());

        // $input = $request->all();
        // $id_categorias = $input['id_categoria'];
        // $user_created = User::where('email', $email)->first();
        // foreach($id_categorias as $id_categoria){
        //     $newuser_not = new UserNotificacion();
        //     $newuser_not->id_user = $nuevo_usuario->id;
        //     $newuser_not->id_categoria_material= $id_categoria;
        //     $newuser_not->estado = 1;
        //     $newuser_not->save();
            
        // }

        // $nuevo_usuario->roles()->sync([$request->input("rol_id")]);
        RolUser::create([
            "rol_id" => $request->input("rol_id"),
            "user_id" => $nuevo_usuario->id
        ]);

        return  redirect()->action([UserController::class, 'index'])
                        ->with('success','Usuario creado con éxito.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function update(Request $request, User $user)
    public function update(Request $request)
    {
 
        $request->validate([
            'nombre' => 'required',
            'email' => 'required',
        ]);

        $user = User::find($request->input("user_id"));
        
        if( $request->input("password")  || ( $user->email != $request->input('email')  ) ){

            $email = $request->input("email"); 
            $clave = $request->input("password");
            $this->enviaEmail('mails.nuevo_usuario_email', ['email'=> $email ,'clave' => $clave ] , $request->input("email")  , 'Datos Usuario Gestion Jc', '');
        }


        $arr_update = $request->all();

        // if(is_null( $request->input('password') ) ){

            // unset($arr_update['password']);

        // }else{
        if($request->input("password") != ""){

            $arr_update['password'] = Hash::make($request->input("password")); 
        }else{
            unset($arr_update['password']);
        }

        $user->update($arr_update);
        // $user->roles()->sync($request->input('rol_id'));

        RolUser::where("user_id", "=", $user->id)->delete();
        RolUser::create([
            "rol_id" => $request->input("rol_id"),
            "user_id" => $user->id
        ]);

        // $input = $request->all();
        // $id_categorias = $input['id_categoria'];
        // $user_created = User::where('email', $input['email'])->first();
        // $user_notification = UserNotificacion::where('id_user',$user_created->id)->get();
       
        // if($user_notification){
        //     foreach ($user_notification as $key) {
        //         // dd($key->id);
        //         $user = UserNotificacion::find($key->id);
        //         $user->delete();
        //     }

        //     // foreach($id_categorias as $id_categoria){
        //     //     $newuser_not = new UserNotificacion();
        //     //     $newuser_not->id_user = $user_created->id;
        //     //     $newuser_not->id_categoria_material= $id_categoria;
        //     //     $newuser_not->estado = 1;
        //     //     $newuser_not->save();
                
        //     // }
        // }
    
        return  redirect()->action([UserController::class, 'index'])
                        ->with('success','Usuario editado con éxito.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, User $user)
    {   
        $estado = 0;
        if($request->input('activo_inactivo')){
            $estado = 1;
        }
        $user->estado = $estado;
        $user->save();
        return  redirect()->action([UserController::class, 'index'])
                        ->with('success','Usuario desactivado con éxito.');
    }

    public function creaUsuario(Request $request)
    {
        $request->request->add(['password' => Hash::make($request->input("rut"))]); 
        $usuario = User::create($request->all());
        $usuario->roles()->sync([4]);
        return  collect([ $usuario->load('Empresa')]);
    }

    public function creaCliente(Request $request)
    {
        // $request->request->add(['password' => Hash::make($request->input("rut"))]); 
        $rut = $request->input('rut');
        $rutSinPuntos = str_replace('.', '', $rut);
        $request->merge(['rut' => $rutSinPuntos]);
        
        $usuario = User::create($request->all());
        // $usuario->roles()->sync([4]);
        
        RolUser::where("user_id", "=", $usuario->id)->delete();
        RolUser::create([
            "rol_id" => 2, //rol CLIENTE
            "user_id" => $usuario->id
        ]);
        
        // return  collect([ $usuario->load('Empresa')]);
        return  collect([ $usuario ]);
    }


}
