<?php

namespace App\Http\Controllers\Repuestos;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;

use App\Models\CategoriaMateriales;

use App\Http\Traits\MetodosGlobales;
use App\Models\Bodega;
use App\Models\MarcaVehiculo;
use App\Models\ModeloVehiculo;

class MarcasModelosController extends Controller
{
    
    use MetodosGlobales;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $c = MarcaVehiculo::orderBy("nombre")->get();

        $datos = [
            "marcas" => $c

        ];

        return view('marcas_modelos.index', $datos);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    // public function create()
    // {
    //     return view('turnos.create');
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $request->validate([
            'nombre' => 'required',
        ]);

        $nuevo = MarcaVehiculo::create($request->all());



        return  redirect()->action([MarcasModelosController::class, 'index'])
                        ->with('success','Marca creada con éxito.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function show(User $user)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function edit(User $user)
    // {
    //     //
    // }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, MarcaVehiculo $b)
    {   
        $request->validate([
            'nombre' => 'required',
        ]);

        $c = MarcaVehiculo::find($request->input("marca_id"));

        $c->nombre = $request->input("nombre");
        $c->save();
    
        return  redirect()->action([MarcasModelosController::class, 'index'])
                        ->with('success','Marca editada con éxito.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, MarcaVehiculo $b)
    {   
        // dd($request->all());
        $estado = 0;
        $mensaje = "Marca desactivada con éxito.";

        $c = MarcaVehiculo::find($request->input("marca_id"));


        if($request->input('activo_inactivo')){
            $estado = 1;
            $mensaje = "Marca activada con éxito.";
        }
        $c->estado = $estado;
        $c->save();


        return  redirect()->action([MarcasModelosController::class, 'index'])
                        ->with('success', $mensaje);
    }


    public function EditaCampoEnTablaMarcaVehiculo(Request $request){

        MarcaVehiculo::where('id', '=', $request->input('id'))->update([ $request->input('campo') => $request->input('val')]); 
        return ['val' => $request->input('val') , 'id' => $request->input('id') ];

    }

    public function CambiaEstadoModelo(Request $request )
    {   
        $m = ModeloVehiculo::find($request->input('modelo_id'));
        
        $estado = 0;
        $mensaje = 'Modelo desactivado con éxito.';

        if($request->input('activo_inactivo')){
            $estado = 1;
            $mensaje = 'Modelo activado con éxito.';
            
        }
        $m->estado = $estado;
        $m->save();
        // return  redirect()->action([MarcasModelosController::class, 'index'])
                        // ->with('success',$mensaje);
        return [
            "error" => false,
            "mensaje" => $mensaje
        ];
    }

    public function CrearNuevoModelo(Request $request){
        $request->validate([
            'id_marca' => 'required',
            'nombre_modelo' => 'required',
            'anio' => 'required'
        ]);

        $m = new ModeloVehiculo;
        $m->marca_vehiculo_id = $request->input("id_marca");
        $m->nombre = $request->input("nombre_modelo");
        $m->anio = $request->input("anio");
        $m->save();

        return [
            "error" => false,
            "mensaje" => "Se ha creado nuevo modelo con exito"
        ];
    }

}
