<?php

namespace App\Http\Controllers\Repuestos;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;

use App\Models\CategoriaMateriales;

use App\Http\Traits\MetodosGlobales;
use App\Models\Bodega;

class CategoriaRepuestosController extends Controller
{
    
    use MetodosGlobales;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $c = CategoriaMateriales::orderBy("nombre")->get();

        $datos = [
            "categorias" => $c

        ];

        return view('categoria_repuestos.index', $datos);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    // public function create()
    // {
    //     return view('turnos.create');
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $request->validate([
            'nombre' => 'required',
        ]);

        $nuevo = CategoriaMateriales::create($request->all());



        return  redirect()->action([CategoriaRepuestosController::class, 'index'])
                        ->with('success','Categoría creada con éxito.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function show(User $user)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function edit(User $user)
    // {
    //     //
    // }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CategoriaMateriales $b)
    {   
        $request->validate([
            'nombre' => 'required',
        ]);

        $c = CategoriaMateriales::find($request->input("categoria_repuesto_id"));

        $c->nombre = $request->input("nombre");
        $c->save();
    
        return  redirect()->action([CategoriaRepuestosController::class, 'index'])
                        ->with('success','Categoría editada con éxito.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, CategoriaMateriales $b)
    {   
        // dd($request->all());
        $estado = 0;
        $mensaje = "Categoría desactivada con éxito.";

        $c = CategoriaMateriales::find($request->input("categoria_repuesto_id"));


        if($request->input('activo_inactivo')){
            $estado = 1;
            $mensaje = "Categoría activada con éxito.";
        }
        $c->estado = $estado;
        $c->save();


        return  redirect()->action([CategoriaRepuestosController::class, 'index'])
                        ->with('success', $mensaje);
    }

}
