<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;

use App\Models\Materiales;

use App\Models\MaterialDestinado;
use App\Models\MaterialesEntregados;
use App\Models\AumentoStock;
use App\Models\DevolucionMateriales;

use App\Models\Usuarios\User;
use App\Models\Empresa;

use App\Http\Traits\MetodosGlobales;
use App\Models\CategoriaMateriales;
use App\Models\MaterialInformeCable;
use App\Models\ChecklistReparaCable;
use App\Models\InformeSenialetica;
use App\Models\MarcaVehiculo;
use App\Models\ModeloVehiculo;

use Illuminate\Support\Facades\Auth;


class MaterialesController extends Controller
{
    
    use MetodosGlobales;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function Materiales(Request $request, $bodega_id)
    {
        // dd($id_bodega);
        $materiales = Materiales::with('CategoriaMateriales')
            ->where("estado", "=", 1)
            ->where("bodega_id", "=", $bodega_id)
            ->orderBy('id','desc')
            ->get();
        // $empresas = Empresa::all();
        $users = User::where("estado", "=", 1)->get();
        $categorias = CategoriaMateriales::where("estado", "=", 1)->orderBy("nombre")->get();
        $marcas = MarcaVehiculo::where("estado", "=", 1)->orderBy("nombre")->get();
        
        return view('materiales',compact(
            'materiales',
            'users', 
            'categorias', 
            'bodega_id',
            'marcas'
        ));

    }

    public function EntregaMateriales(Request $request)
    {
        

        if (view()->exists($request->path())) { 
            $materiales = Materiales::orderBy('id')->get();
            $empresas = Empresa::all();
            return view('entrega_materiales',compact('materiales','empresas'));
        }
        return abort(404);
    }


    // public function root(Request $request)
    // { 
    //     $materiales = Materiales::all();
    //     $empresas = Empresa::all();
    //     $origen = config('constants.origen_material');
    //     return view('index',compact('materiales','empresas','origen'));
        
    // }

    public function MaterialesEntregados(Request $request)
    {

        $arr_bajo_stock = [];
        foreach ($request->input('materiales') as $key => $value) {

            MaterialesEntregados::create( [ 'user_recibe_id' => $request->input('user_recibe_id') ,
                                            'user_entrega_id' => $request->input('user_entrega_id') ,
                                            'cantidad' => $value['cantidad'] ,
                                            'material_id' => $value['material'] ]  );

            $stock = Materiales::where('id', '=', $value['material'])->select('stock','stock_critico')->first();
 
            $retorno = Materiales::where('id', '=', $value['material'])->update(['stock' => $stock->stock - $value['cantidad'] ]);
            
            if( ( $stock->stock - $value['cantidad'] ) <   $stock->stock_critico ){

                 $arr_bajo_stock[$value['material']]['material']  = $value['nom_material'] ;

                 $arr_bajo_stock[$value['material']]['quedan']  = $stock->stock - $value['cantidad'] ;
            }

        }

        if(count($arr_bajo_stock)){

            $email = Auth::user()->email;
            $subject = 'Reporte bajo stock';
       
            $this->enviaEmail('mails.falta_stock_email', ['arr_bajo_stock' => $arr_bajo_stock] , $email , $subject, 0 );
            
        }
  
        return  redirect()->action([MaterialesController::class, 'EntregaMateriales'])
                    ->with('success','Material entregados con éxito');     
 
    }

    public function CreaMaterial(Request $request){
 
       if($request->hasFile("image")){

            $ruta_img = 'app/assets/images/materiales/images';
            $ruta_thumbnail = 'app/assets/images/materiales/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("image"),  $ruta_img , $ruta_thumbnail);
            $request->request->add(['imagen' => $nombre_archivo]);

        } 

        Materiales::create($request->all());

        // return  redirect()->action([MaterialesController::class, 'Materiales'])
        //             ->with('success','Material creado con éxito');
        return redirect()->action([MaterialesController::class, 'Materiales'], ['bodega_id' => $request->input("bodega_id")])
                    ->with('success', 'Material creado con éxito');

    } 

    public function CargaMaterial(Request $request){
        
        return $stock = Materiales::where('id', '=', $request->input('id'))->first();

    }

    public function DevolverMaterial(Request $request)
    {
 
        foreach ($request->input('material') as $key => $value) {
            DevolucionMateriales::create( [                                         
                                            'cantidad' => $value['cantidad'],
                                            'material_id' => $key,
                                            'user_entrega_id' => $request->input('user_entrega_id'),
                                            'user_recibe_id' => Auth::user()->id ]  );

            $stock = Materiales::where('id', '=', $key)->select('stock')->first();
            Materiales::where('id', '=', $key)->update(['stock' => $stock->stock + $value['cantidad'] ]);

        }

        return  redirect()->action([MaterialesController::class, 'DevolucionMateriales'])
                    ->with('success','Materiales devueltos con éxito');
 
    }

    public function DevolucionMateriales(Request $request)
    {
        $materiales = Materiales::all();
        $empresas = Empresa::all();
        $user = User::all();

        return view('devolucion_material',compact('materiales','empresas','user'));
 
    }

    
    public function EditaImg(Request $request){

       if($request->hasFile("imagen_material")){

            $ruta_img = 'app/assets/images/materiales/images';
            $ruta_thumbnail = 'app/assets/images/materiales/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("imagen_material"),  $ruta_img , $ruta_thumbnail);
            $request->request->add(['imagen' => $nombre_archivo]);

        }

        $retorno = Materiales::where('id', '=', $request->input('id'))->update(['imagen' => $nombre_archivo ]);

        // return ['id' => $request->input('id') , 'imagen' => $nombre_archivo , 'nombre' => $request->input('nombre') ];       
        return  redirect()->action([MaterialesController::class, 'Materiales'])
                    ->with('success','Imagen cargada con exito');

    }

    public function EditaCampoEnTabla(Request $request){

        Materiales::where('id', '=', $request->input('id'))->update([ $request->input('campo') => $request->input('val')]); 
        return ['val' => $request->input('val') , 'id' => $request->input('id') ];

    }

    public function AumentoStock(Request $request){

        if($request->hasFile("document")){

            $ruta_img = 'app/assets/images/aumento_stock/images';
            $ruta_thumbnail = 'app/assets/images/aumento_stock/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("document"),  $ruta_img , $ruta_thumbnail);

        }

        $request->request->add(['documento' => $nombre_archivo]);

        $stock = Materiales::where('id', '=',  $request->input('material_id'))->select('stock')->first();
        Materiales::where('id', '=', $request->input('material_id'))->update([ 'stock' => $stock->stock + $request->input('cantidad')]);
        AumentoStock::create($request->all());

        return  redirect()->action([MaterialesController::class, 'Materiales'])
                    ->with('success','Stock aumentado con éxito');

    }

    public function ModelosPorMarca(Request $request){
        // Obtener el valor de id_marca desde la solicitud POST
        $idMarca = $request->input('id_marca');

        // Consultar modelos filtrados por la marca_vehiculo_id
        $modelos = ModeloVehiculo::where('marca_vehiculo_id', $idMarca)->get();

        // Retornar los resultados en formato JSON
        return response()->json(['error' => false, 'modelos' => $modelos]);
    }

}