<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;

use App\Models\Materiales;
use App\Models\Usuarios\User;
use App\Models\Empresa;
use App\Models\InformeCable;
use App\Models\MaterialesEntregados;
use App\Models\MaterialInformeCable;
use App\Models\DevolucionMateriales;


use App\Models\EvidenciaAntesDespues;
use App\Models\InformeSenialetica;
use App\Models\MaterialInformeSenialetica;

use App\Http\Traits\MetodosGlobales;

use PDF;
use DB;
use Carbon\Carbon;

class BuscaInformesController extends Controller
{

    public function index(Request $request)
    {
 
        return view('informes.index');
      
    }

    public function ResultadoBuscaInformes(Request $request)
    {
        
        $data['user'] = User::with('Empresa')->where('rut', '=', str_replace('.', '', $request->input('trabajador')) )->first();
        $data['informes'] = 0;
        $data['categoria'] = 'sin resultados';
        $data['fecha_inicio'] = $request->input('fecha_inicio');
        $data['fecha_fin'] = $request->input('fecha_fin');
        $data['trabajador'] = $request->input('trabajador');
        $data['checked_senialetica'] = '';
        $data['checked_cable'] = ''; 
        $startDate = Carbon::createFromFormat('Y-m-d', $request->input('fecha_inicio'))->startOfDay();
        $endDate = Carbon::createFromFormat('Y-m-d', $request->input('fecha_fin'))->endOfDay();
        // dd($endDate);
        // if (Carbon::createFromFormat('Y-m-d', $request->input('fecha_fin')) == Carbon::now()) {
        //     $endDate = Carbon::now();
        // }else{
        //     $endDate = Carbon::createFromFormat('Y-m-d', $request->input('fecha_fin'));
        // }
       // dd($request->all());
        if( $data['user'] && ($request->input('tipo_informe') == 'senialetica' || $request->input('tipo_informe') == 'cables' )){

            
            if($request->input('tipo_informe') == 'senialetica' ){

                $data['tipo_informe'] = 'senialetica';
                $data['informes'] = InformeSenialetica::where('user_id', $data['user']->id)->orderBy('created_at','desc')->whereBetween('created_at', [$startDate, $endDate])->latest()->paginate(12);
                $data['categoria'] = 'de Señaletica';
                $data['checked_senialetica'] = 'checked';

            }else{

                $data['tipo_informe'] = 'cables';
                $data['informes'] = InformeCable::where('user_id', $data['user']->id)->orderBy('created_at','desc')->whereBetween('created_at', [$startDate, $endDate])->latest()->paginate(12);
                $data['categoria'] = 'de Cables';
                $data['checked_cable'] = 'checked';                
            }


        }

        return view('informes.busca_informes', $data);
      
    }




    public function DetalleInforme(Request $request)
    {
      
                    //     <span>Nombre :</span><span id="nombre_informe">{{ $user->nombre }} {{ $user->apellido_paterno }} {{ $user->apellido_materno }}</span>         
                    // </div>                 
                    // <div class="col-md-3">
                    //     <span>Rut :</span><span id="rut_informe">{{ $user->rut }}</span>   
                    // </div>
                    // <div class="col-md-3">
                    //     <span>Empresa :</span><span id="empresa_informe">{{ $user->Empresa->nombre }}</span>   
                    // </div>        
                    // <div class="col-md-3">
                    //     <span>Email :</span><span id="email_informe">{
            $retornotecnico = [ "nom_tecnico" => $request->input('nom_tecnico'),
                                "rut_tecnico" => $request->input('rut_tecnico'),
                                "nom_empresa" => $request->input('empresa_tecnico'),
                                "email_tecnico" => $request->input('email_tecnico')
                            ]; 
                                 
        if($request->input('tipo') == 'senialetica'){

            $InformeSenialetica = InformeSenialetica::where('id', $request->input('id'))->get()[0];
     
            $MaterialInformeSenialetica = MaterialInformeSenialetica::where('informe_senialetica_id','=', $InformeSenialetica->id )->pluck('material_id');
            $retornomateriales = Materiales::whereIn('id',$MaterialInformeSenialetica->toArray())->get();

            $evidencia_antes_despues = EvidenciaAntesDespues::where('informe_senialetica_id' , $InformeSenialetica->id )->get();     

            $pdf = App::make('dompdf.wrapper');

            $pdf->loadHTML(view('mails.senialetica_pdf2',  compact('InformeSenialetica','retornomateriales','evidencia_antes_despues','retornotecnico')))->setPaper('legal', 'portrait');
            return $pdf->stream();
            
        }else{

       // $retornomateriales = $request->input('material');
        //$retornotecnico = $request->input('tecnico');

        $checklistreparacable = InformeCable::where('id', $request->input('id'))->get()[0];

        $MaterialInformeCable = MaterialInformeCable::where('informe_cable_id','=', $checklistreparacable->id )->pluck('material_id');
        $retornomateriales = Materiales::whereIn('id',$MaterialInformeCable->toArray())->get();


 
       // $checklistreparacable->load('User')->load('Empresa');
     
       // $archivoPDF = PDF::loadView('mails.reparacion_cables_pdf2', compact('checklistreparacable','retornomateriales','retornotecnico'))->setPaper('legal', 'portrait'); 
        $estadosUnidadesMedida = [
            1 => "MegaOhm",
            2 => "GigaOhm",
            3 => "TeraOhm",
            4 => "Falla"
        ];

            $pdf = App::make('dompdf.wrapper');

            $pdf->loadHTML(view('mails.reparacion_cables_pdf2', compact('checklistreparacable','retornomateriales','retornotecnico', 'estadosUnidadesMedida')))->setPaper('legal', 'portrait');
            return $pdf->stream();



        }
       
      
    }
    


}
