<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use App\Mail\EnvioEmailInforme;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\Exportable;

class EnviaEmailInformeVentasDiarias extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'emails:ventas';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envia informe de ventas diario';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $yesterdayStart = now()->subDay()->startOfDay()->format('Y-m-d H:i:s');
        $yesterdayEnd = now()->subDay()->endOfDay()->format('Y-m-d H:i:s');
        $todayEnd = now()->endOfDay()->format('Y-m-d H:i:s');

        // Consulta a la vista A
        $dataFromViewA = DB::select("SELECT * FROM informe_ventas WHERE fecha_venta BETWEEN '$yesterdayStart' AND '$yesterdayEnd'");

        // Consulta a la vista B usando los ids obtenidos de la vista A
        $idsFromViewA = array_column($dataFromViewA, 'venta_id');
        $dataFromViewB = DB::table('informe_ventas_detalle')->whereIn('venta_id', $idsFromViewA)->get();

        // Ajustar valores nulos o 0 para mostrar "0" en el archivo Excel
        $dataFromViewA = $this->adjustValues($dataFromViewA);
        $dataFromViewB = $this->adjustValues($dataFromViewB);

        // Generar el archivo Excel con dos hojas, una para cada vista, usando Excel::raw
        $headers = !empty($dataFromViewA) ? array_keys((array) $dataFromViewA[0]) : [];

        $fileInMemory = Excel::raw(new class($dataFromViewA, $dataFromViewB) implements WithMultipleSheets {
            private $dataFromViewA;
            private $dataFromViewB;
            use Exportable;

            // protected $year;

            public function __construct($dataFromViewA, $dataFromViewB)
            {
                $this->dataFromViewA = $dataFromViewA;
                $this->dataFromViewB = $dataFromViewB;
            }
            
            public function sheets(): array
            {
                $sheets = [];

                // for ($month = 1; $month <= 12; $month++) {
                    // $sheets[] = new InvoicesPerMonthSheet($this->year, $month);
                    $sheets[] = new HojaExcel("Ventas", $this->dataFromViewA);
                    $sheets[] = new HojaExcel("Detalle Ventas", $this->dataFromViewB);

                // }

                return $sheets;
            }
        }, 'Xlsx');

        $customMessage = "Se envía Informe de Ventas Diarias.";

        // Enviar correos a los destinatarios
        $recipients = explode(',', env('DESTINATARIOS_INFORME_VENTAS_DIARIAS'));
        foreach ($recipients as $recipient) {
            Mail::to($recipient)->send(new EnvioEmailInforme($fileInMemory, $customMessage));
        }
    }

    // Función para ajustar valores nulos o 0 a "0"
    private function adjustValues($data)
    {
        foreach ($data as &$row) {
            foreach ($row as &$value) {
                $value = is_null($value) || $value === 0 ? '0' : $value;
            }
        }
        return $data;
    }
}

class HojaExcel implements FromCollection, WithTitle
{
    private $datos;
    private $titulo;

    public function __construct($titulo, $datos)
    {
        $this->titulo = $titulo;
        $this->datos = $datos;
    }
    /**
     * @return Builder
     */
    // public function query()
    // {
    //     return [];
    // }
    public function collection()
    {
        $collectionA = collect([array_keys((array) $this->datos[0])]);
        foreach ($this->datos as $row) {
            $formattedRow = array_map(function ($value) {
                return ($value === null || $value === 0) ? "0" : $value;
            }, (array) $row);
            $collectionA->push($formattedRow);
        }

        return $collectionA;
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return $this->titulo;
    }
};