<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\InformeController;
use App\Http\Controllers\MaterialesController;
use App\Http\Controllers\Usuarios\UserController;
use App\Http\Controllers\Bodegas\BodegasController;
use App\Http\Controllers\Graficos\CablesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Auth::routes();


Route::get('grafico_cables', [App\Http\Controllers\Graficos\CablesController::class, 'index']);

Route::get('graficosmateriales', [App\Http\Controllers\Graficos\CablesController::class, 'graficosMateriales']);
Route::get('grafico_user', [App\Http\Controllers\Graficos\CablesController::class, 'GraficoUser']);



Route::get('graficosmateriales2', [App\Http\Controllers\Graficos\Cables2Controller::class, 'graficosMateriales']);
Route::get('grafico_user2', [App\Http\Controllers\Graficos\Cables2Controller::class, 'GraficoUser']);

Route::resource('users', UserController::class);
Route::get('creausuario', [App\Http\Controllers\Usuarios\UserController::class, 'CreaUsuario']);

Route::get('materiales/{bodega_id}', [App\Http\Controllers\MaterialesController::class, 'Materiales']);

Route::get('/', [App\Http\Controllers\HomeController::class, 'index']);

Route::get('index', [App\Http\Controllers\MaterialesController::class, 'index']);
Route::get('entrega_materiales', [App\Http\Controllers\MaterialesController::class, 'EntregaMateriales']);

Route::get('devolver_materiales', [App\Http\Controllers\MaterialesController::class, 'DevolverMaterial']);

Route::get('materiales_entregados', [App\Http\Controllers\MaterialesController::class, 'MaterialesEntregados']);
Route::get('edita_campo_en_tabla', [App\Http\Controllers\MaterialesController::class, 'EditaCampoEnTabla']);
Route::post('edita_img', [App\Http\Controllers\MaterialesController::class, 'EditaImg']);
Route::get('carga_material', [App\Http\Controllers\MaterialesController::class, 'CargaMaterial']);
Route::post('aumento_stock', [App\Http\Controllers\MaterialesController::class, 'AumentoStock']); 
Route::post('creamaterial', [App\Http\Controllers\MaterialesController::class, 'CreaMaterial']);
Route::get('devolucion_materiales', [App\Http\Controllers\MaterialesController::class, 'DevolucionMateriales']);

Route::post('modelos_por_marca', [App\Http\Controllers\MaterialesController::class, 'ModelosPorMarca']); 


Route::get('informes', [App\Http\Controllers\InformeController::class, 'index']);


Route::get('reparacion_cables_mina', [App\Http\Controllers\InformeController::class, 'reparacion_cables_mina']);
Route::post('guardasenialetica', [App\Http\Controllers\InformeController::class, 'GuardaSenialetica']);

Route::get('senialetica', [App\Http\Controllers\InformeController::class, 'InformeSenialetica']);
 


Route::get('selectusuario', [App\Http\Controllers\InformeController::class, 'SelectUsuario']);
Route::get('guardachecklistreparacable', [App\Http\Controllers\InformeController::class, 'GuardaChecklistReparaCable']);

Route::post('notify_centinela/{id_informe}', [App\Http\Controllers\InformeController::class, 'NotifyCentinela']);

Route::get('busca_informes', [App\Http\Controllers\BuscaInformesController::class, 'index']);
Route::get('resultado_busca_informes', [App\Http\Controllers\BuscaInformesController::class, 'ResultadoBuscaInformes']);


Route::get('detalle_informe', [App\Http\Controllers\BuscaInformesController::class, 'DetalleInforme']);

Route::resource('bodegas', BodegasController::class);
