@extends('layouts.master_no_login')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />    

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        
    @media (max-width: 500px) {
        .facet_sidebar {
            border-bottom: solid 1px #000;
            padding-bottom: 10px;
        }
    }

    input[type="text"]:disabled {
      background: #9295a4;
    }

        .imagen_carga{
            width: 300px;
        }

        .recorte {
           width: 50px;
            height: 50px;
            overflow: hidden;
            margin: 10px;
            position: relative;
            float: left;
        }

        .recorte img {
            position:absolute;
            left: -100%;
            right: -100%;
            top: -100%;
            bottom: -100%;
            margin: auto;
            min-height: 100%;
            min-width: 100%;
        }
         
        .custom-file-input {
          color: transparent;
          width: 115px;
        }
        .custom-file-input::-webkit-file-upload-button {
          visibility: hidden;
        }
        .custom-file-input::before {
          content: 'Cargar';
          color: black;
          display: inline-block;
          background: -webkit-linear-gradient(top, #f9f9f9, #e3e3e3);
          border: 1px solid #999;
          border-radius: 3px;
          padding: 5px 8px;
          outline: none;
          white-space: nowrap;
          -webkit-user-select: none;
          cursor: pointer;
          text-shadow: 1px 1px #fff;
          font-weight: 700;
          font-size: 10pt;
        }
        .custom-file-input:hover::before {
          border-color: black;
        }
        .custom-file-input:active {
          outline: 0;
        }
        .custom-file-input:active::before {
          background: -webkit-linear-gradient(top, #e3e3e3, #f9f9f9); 
        }
        .valor_stock{

            width: 70px;
            text-align: left;
            margin-right: 9px;
            float: left;
            padding: 3px;
            border: solid 1px #fff
        },

    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Informes @endslot
        @slot('title') Trabajos de Instalación, Retiro y Mantención de Señaléticas Área Mina. Mina @endslot
    @endcomponent
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Ingrese su rut</h4>
                <div class="row">
                    <div class="col-md-8">                      
                        <input type="text" class="form-control" id="rut_user" value="">              
                    </div>
                    <div class="col-md-2">                      
    					<button class="btn btn-primary" type="submit" id="busca_user" onclick="buscaUser()">Buscar</button>      
                    </div>
                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col -->
</div>

<form  class="custom-validation" action="guardasenialetica" id="form_informe_cables"  enctype="multipart/form-data" method="POST" style="display: none"  >
    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Entregado por Jc Servios</h4>
                    <div class="row">
                        <div class="col-md-3">                      
                            <span>Nombre: </span><span id="nombre_entrega"></span>         
                        </div>                 
                        <div class="col-md-2">
                            <span>Rut: </span><span id="rut_entrega"></span>   
                        </div>
                        <div class="col-md-3">
                            <span>Empresa: </span><span id="empresa_entrega"></span>   
                        </div>        
                        <div class="col-md-4">
                            <span>Email: </span><span id="email_entrega"></span>   
                        </div>  
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>    
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">DOCUMENTOS INVOLUCRADOS</h4>
                    <div class="row">
                        <div class="col-md-4">     
                            <input type="checkbox" id="checkbox_e_tecnica" class="switch_F" data-inputtext="id_especificacion_tecnica" switch="none" value="1" checked name="checkbox_e_tecnica"  />
                            <label for="checkbox_e_tecnica"  data-on-label="Si" data-off-label="No"></label>  
                            <label class="form-label" for="especificacion_tecnica" style="float: right; padding-right: 110px;">Especificación tecnica</label>
                            <input type="text" class="form-control" id="id_especificacion_tecnica" name="doc_especificacion_tecnica" required>   
                        </div>
             
                        <div class="col-md-4">
                            <input type="checkbox" id="checkbox_planos" class="switch_F" data-inputtext="id_planos"  switch="none" value="1" checked name="checkbox_planos"  />
                            <label for="checkbox_planos"  data-on-label="Si" data-off-label="No"></label>  

                            <label class="form-label" for="id_planos"  style="float: right; padding-right: 160px;">Planos</label>
                            <input type="text" class="form-control" id="id_planos" name="doc_planos" required> 
                        </div>
                        <div class="col-md-4">
                            <input type="checkbox" id="checkbox_otros" class="switch_F"  data-inputtext="id_otros" switch="none"  value="1" checked name="checkbox_otros"  />
                            <label for="checkbox_otros"  data-on-label="Si" data-off-label="No"></label>  

                            <label class="form-label" for="id_otros"  style="float: right; padding-right: 160px;">Otros</label>
                            <input type="text" class="form-control" id="id_otros" name="doc_otros" required>  
                            <input type="hidden" name="user_id" id="user_id">  
                            <input type="hidden" name="empresa_id" id="empresa_id" value="84">

                            <input type="hidden" name="tecnico[nom_tecnico]" id="nom_tecnico">  
                            <input type="hidden" name="tecnico[rut_tecnico]" id="rut_tecnico">
                            <input type="hidden" name="tecnico[nom_empresa]" id="nom_empresa">  
                            <input type="hidden" name="tecnico[email_tecnico]" id="email_tecnico">                             

                        </div>        
                    </div>
                </div>
            </div>
            <!-- end card -->
        </div> <!-- end col -->
    </div>
    <div class="row">
    	<h1>OBSERVACIONES Y COMENTARIOS:</h1>
    </div>    
    <div class="row">
 
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Observaci&oacute;n</h4>
                    <div class="row">
 						<div class="mb-3 col-lg-12">
                            <textarea id="observacion" name="observacion" class="form-control"  height="55"  required></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
     <!-- end row --> 

    <!-- end row --> 
    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">Materiales en terreno</h4>
                    <div class="form-row">
                        <div class="row popup-gallery" id="carga_materiales">
                          
    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row--> 
    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">EVIDENCIA ANTES Y DESPUES</h4>
                        <div class="repeater" >
                            <div data-repeater-list="evidencia_antes_despues">
                                <div data-repeater-item class="row">
                                    <div class="mb-3 col-lg-2">
     
                                        <div class="custom-radio form-check form-check-inline">
                                            <input type="radio" id="" value="impit" name="impit_expit"
                                                class="form-check-input">
                                            <label class="form-check-label" for="" required>Impit</label>
                                        </div>
                                        <div class="custom-radio form-check form-check-inline">
                                            <input type="radio" id="" value="expit" name="impit_expit"
                                                class="form-check-input">
                                            <label class="form-check-label" for="" required>Expit</label>
                                        </div>
                                    </div>
                                    <div class="mb-3 col-lg-4">
                                        <label class="form-label" for="message">Descripción Ubicación</label>
                                        <textarea id="message" class="form-control" name="descripcion_ubicacion" required></textarea>
                                    </div>

                                    <div class="mb-3 col-lg-2">
                                        <label class="form-label" for="resume">Imagen Antes</label>
                                        <input type='file' onchange="readImage(this)" class="custom-file-input" id="" required  accept="image/*" value="Cargar Imagen" name="imagen_antes" />
                                        <img src="" name="img"  width="50">
                                    </div>

                                    <div class="mb-3 col-lg-2">
                                        <label class="form-label" for="resume">Imagen Despues</label>
                                        <input type='file' onchange="readImage(this)" class="custom-file-input" id=""  required accept="image/*" value="Cargar Imagen" name="imagen_despues" />
                                        <img src="" name="img"  width="50">
                                    </div>

                                    <div class="col-lg-2 align-self-center d-grid">
                                        <input data-repeater-delete type="button" class="btn btn-primary btn-block"
                                            value="Eliminar" />
                                    </div>
                                </div>

                            </div>
                        <input data-repeater-create type="button" class="btn btn-success mt-3 mt-lg-0" value="Agregar" />
                    </div>
                </div>
            </div>
        </div>
    </div><!--end row-->
 

    <button class="btn btn-primary" type="submit">Enviar</button>
</form>

@endsection
@section('script')

    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
  
    <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jquery-repeater/jquery-repeater.min.js') }}"></script>


    <script src="{{ URL::asset('/assets/js/jquery.Rut.js')}}"></script>
    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>


    <script type="text/javascript">

    function buscaUser(rut){ 
  
        var rut_user = $("#rut_user").val();

        $.get("selectusuario?material_id=2&rut_user="+rut_user,function(response){

            $("#form_informe_cables").hide();

            if(response == 'No existe el Usuario'){

                alert(response);
                return;
            }

            if( typeof response != 'string'){

                if(!response[1].length){

                    alert('Trabajador sin materiales');
                    return;

                }

                var cantidadFinal = 0;
                for(var i in response[1]){
                    var material = response[1][i];

                    cantidadFinal += material["cantidad"];
                }

                console.log("cantidadFinal", cantidadFinal);

                if(cantidadFinal == 0){

                    alert('Trabajador sin materiales');
                    return;

                }

        		cargaResponsable(response);

        	}else{
        		$("#exampleModal").modal('show');
        		$("#recipient-rut").val(response);
        	}

        });        

    }
    function readImage(input) {
        var _URL = window.URL || window.webkitURL;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {

               $(input).next().attr('src', e.target.result );
           //    $(input).next().next().val( e.target.result );
                img = new Image();
                var objectUrl = _URL.createObjectURL(input.files[0]);
                img.onload = function () {
                 
                    // $(input).parent().prev().children().removeAttr('width').removeAttr('height'); // se eliminan atributos 

                    // if(this.width < this.height){ // segun sea el caso , para que la imagen se sentre si es apiasada  o no 
                    //     $(input).parent().prev().children().attr('src', e.target.result).attr('width','50'); 
                    // }else{
                    //      $(input).parent().prev().children().attr('src', e.target.result).attr('height','50');
                    // }

                };
                 // $(input).parent().prev().children().click();
                // Swal.fire({
                //     position: 'top-center',
                //     icon: 'success',
                //     title: 'Editado con éxito',
                //     showConfirmButton: true,
                //     timer: 31500,
                //     html: "<img src='"+e.target.result+"' alt='Google'  width='200' >",
                //     customClass: 'class-name',
                // }); 
             //   $("#modalImagen").modal("show");
                img.src = objectUrl;

            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function cantidadEntregaMaterial(input){

        var newValue = input.val();
        var id = input.data('id');
        if( parseInt(newValue) > parseInt(input.attr('max'))){
            console.log(1);
            input.val('');
            $("#id_material_"+id).text(input.attr('max'));

        }else{

            if(newValue != ''){

                var nuevo_valor = parseInt(input.parent().prev().val()) - parseInt(newValue);
                $("#id_material_"+id).text(nuevo_valor);

            }
            if(newValue == 0 ){
 
                $("#id_material_"+id).text(input.attr('max'));

            }
        }

        if( nuevo_valor < 0 ){

            $("#id_material_"+id).text(input.attr('max'));
            input.val('');

        }

    }

    function cargaResponsable(response){

        $("#user_id").val(response[0].id);
        $("#nombre_entrega").text(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
        $("#rut_entrega").text(response[0].rut);
        $("#email_entrega").text(response[0].email);
        $("#empresa_entrega").text(response[0].empresa.nombre);

        $("#nom_tecnico").text(response[0].nombre +' '+ response[0].apellido_paterno +' '+ response[0].apellido_materno );
        $("#rut_tecnico").val(response[0].rut);
        $("#email_tecnico").val(response[0].email);
        $("#nom_empresa").val(response[0].empresa.nombre);
 
        var html = '';
     
        $.each(response[1], function(k, v){
            

            if(v.cantidad > 0){
                html += '<div class="col-lg-4">';
                html += '    <div class="card" style="border: solid 3px #22252f;">';
                html += '        <div class="row g-0 align-items-center">';
                html += '            <div class="col-md-2">';

                html += '                   <div class="recorte"  id="mini_img_'+v.id+'"  >'; 

                                            if(v.imagen){

                html += '                       <input type="hidden" value="'+v.imagen+'"   name="material['+v.material_id+'][imagen]">';
                html += '                       <a class="" href="/assets/images/materiales/images/'+v.imagen+'"  title="">';
                html += '                           <div class="img-fluid">';
                html += '                               <img src="/assets/images/materiales/thumbnail/'+v.imagen+'" class="img-fluid d-block">';
                html += '                           </div>';
                html += '                       </a>';                                
                                            }else{

                html += '                       <img  src="https://via.placeholder.com/50"   />';
                                            }

                html += '                   </div>';
                html += '            </div>';
                html += '            <div class="col-md-10">';
                html += '                <div class="card-body">';
                html += '                    <h5 class="card-title">'+v.material+'</h5>';
                html += '                    <input type="hidden" value="'+v.material+'"   name="material['+v.material_id+'][nombre]">';
                html += '                    <div class="row g-0 align-items-center">';
                html += '                       <div class=" col-md-4 card-text">Le quedan : <span id="id_material_'+v.material_id+'">'+v.cantidad+'</span></div>';
                html += '                       <div class=" col-md-4 card-text">de : '+v.cantidad+'</div>';
                html += '                       <input type="hidden" value="'+v.cantidad+'">';
                html +='                        <div class=" col-md-4 card-text">';
                html +='                            <input class="material_ocupado form-control" pattern="[0-9]+" type="number" max="'+v.cantidad+'" min="0" data-id="'+v.material_id+'"  required data-parsley-type="number" name="material['+v.material_id+'][cantidad]" >';
                html +='                        </div>';
                html += '                    </div>';
                html += '                </div>';
                html += '                </div>';
                html += '            </div>';
                html += '        </div>';
                html += '    </div>';
                html += '</div>';
            }       

        });

        $("#carga_materiales").html(html);
        $("#form_informe_cables").show(); 
        $(".material_ocupado").keyup(function(){

            cantidadEntregaMaterial($(this));
         
        });

        $(".material_ocupado").change(function(){

            cantidadEntregaMaterial($(this));
         
        });

    }

    $(document).ready(function(){


      $('.repeater').repeater({
        defaultValues: {
          'textarea-input': 'foo',
          'text-input': 'bar',
          'select-input': 'B',
          'checkbox-input': ['A', 'B'],
          'radio-input': 'B'
        },
        show: function show() {
          $(this).slideDown();
        },
        hide: function hide(deleteElement) {
          if (confirm('Seguro de eliminar este elemento')) {
            $(this).slideUp(deleteElement);
          }
        },
        ready: function ready(setIndexes) {}
      });

        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }
        $(".select2").select2();   

        $(".switch_F").change(function(k,v){
            if($(this).prop('checked')){

                $("#"+$(this).data('inputtext')).attr('disabled',false).attr('required','required');

            }else{
 
                $("#"+$(this).data('inputtext')).attr('disabled',true).removeAttr('required');
            }
        });

        $('#rut_user').Rut({
            format_on: 'keyup'             
        });

    });

    </script>
@endsection
