@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
 
    <style type="text/css">
        
    #container {
      height: 400px;
      min-width: 360px;
      max-width: 800px;
      margin: 0 auto;
    }
    input[type="week"]::-webkit-calendar-picker-indicator {
        cursor: pointer;
        border-radius: 4px;
        margin-right: 2px;
        opacity: 0.6;
        filter: invert(0.8);
    }
    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Materiales @endslot
        @slot('title') Entrega de Materiales @endslot
    @endcomponent 


<div class="mb-3 row">
     <div class="col-md-3">
        <input class="form-control" type="week"  value="" id="week-input">
    </div>
     <div class="col-md-8" id="id_mes">
        Mes
    </div>

</div>

<div id="container"></div>

<div class="modal fade bd-example-modal-lg" id="carga_grafico" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      ...
    </div>
  </div>
</div>

@endsection
@section('script')



 
    <script src="{{ URL::asset('/assets/js/highcharts/highstock.js' )}}"></script>
    <script src="{{ URL::asset('/assets/js/highcharts/data.js')}}"></script>
    <script src="{{ URL::asset('/assets/js/highcharts/exporting.js')}}"></script>

    <script src="{{ URL::asset('/assets/js/highcharts/export-data.js')}}"></script>
    
    <script src="{{ URL::asset('/assets/js/highcharts/accessibility.js')}}"></script>
 
    <script src="{{ URL::asset('/assets/js/highcharts/drilldown.js')}}"></script> 

 

<script type="text/javascript">
    
$(function() {

    $("#week-input").change(function(){

        lineasSemana($(this).val());
 
    });

    currentdate = new Date();
    var oneJan = new Date(currentdate.getFullYear(),0,1);
    var numberOfDays = Math.floor((currentdate - oneJan) / (24 * 60 * 60 * 1000));
    var result = Math.ceil(( currentdate.getDay() + 1 + numberOfDays) / 7);

    $("#week-input").val(currentdate.getFullYear()+"-"+"W"+result);

    lineasSemana(0);

});

 function lineasSemana(semana) {
         Highcharts.getJSON('http://127.0.0.1:8000/graficosmateriales?semana='+semana,
            function (data) {
            $("#id_mes").text("Mes "+ " " +data.mes);
            Highcharts.chart('container', {
                chart: {
                    type: 'column'
                },
                title: {
                    text: 'Materiales',
                    align: 'left'
                },
                subtitle: {
                    text: 'Señaletica',
                    align: 'left'
                },
                plotOptions: {
                    column: {
                        grouping: false,
                        colorByPoint: true,
                        shadow: false,
                        borderWidth: 0
                    },series: {
                     cursor: 'pointer',
                    //  point: {
                    //      events: {
                    //         click: function() {
                              
                    //         }
                    //     }
                    // }
                }
                },
                legend: {
                    enabled: false
                },
                tooltip: {
                    shared: true,
                    headerFormat: '<span style="font-size: 15px">{point.point.name}</span><br/>',
                    pointFormat: '<span style="color:{point.color}">\u25CF</span><b>{point.y} Materiales</b><br/>'
                },
                xAxis: {
                    type: 'category',
                    accessibility: {
                        description: 'Countries'
                    },
                 //   max: 6,
                    labels: {
                        useHTML: true,
                        animate: true,
                    }
                },
                yAxis: [{
                    title: {
                        text: 'Materiales'
                    },
                    showFirstLabel: false
                }],
                series: [

                {
                    color: 'rgb(158, 159, 163)',
                    pointPlacement: -0.4,
                    linkedTo: 'main',
                    data: data.semana_devueltos, 
                    name: '2016'
                }, 

                {
                    name: 'Dias Semana',
                    id: 'main',
                    dataSorting: {
                        enabled: true,
                        matchByName: true
                    },
                    dataLabels: [{
                        enabled: true,
                        inside: true,
                        style: {
                            fontSize: '16px'
                        }
                    }],
                    data: data.semana
                }],
                drilldown: {
                  series: data.hijos
                },



                exporting: {
                    allowHTML: true
                }
            });
        });
    }

</script>
@endsection
