function abcdario(letra){

    var abc = ['A', 'B', 'C','D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
    return abc[letra];

}

function  mensajeRetorno(mensaje, icono, tiempoEnPantalla){

    Swal.fire({
            position: 'top-center',
            icon: 'icono',
            title: mensaje,
            showConfirmButton: true,
            timer: tiempoEnPantalla,
            customClass: 'class-name',
        });

}

function editaImagen(id_form, rutas_ajax){

    $.ajax({
        url: rutas_ajax,
        type: "POST",
        data:  new FormData(id_form),
        contentType: false,
        cache: false,
        processData:false,
       beforeSend : function()
       {



       },
       success: function(data)
            {

                var html = '';
                html += '<a href="/assets/images/materiales/images/'+data.imagen+'" title="'+data.nombre+'">';
                html += '   <div class="img-fluid">';
                html += '       <img src="/assets/images/materiales/thumbnail/'+data.imagen+'" alt="" class="img-fluid d-block">';
                html += '   </div>';
                html += '</a>';

                $("#mini_img_"+data.id).html(html);

                mensajeRetorno('Imegen editada con éxito', 'success', 6000);

            },
        error: function(e) 
            {
                $("#err").html(e).fadeIn();
            }          
    });
}

function readImage(input, rutas_ajax) {
    var idform = $(input).parent().attr('id');
    var _URL = window.URL || window.webkitURL;
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) { 

            img = new Image();
            var objectUrl = _URL.createObjectURL(input.files[0]);
            img.onload = function () {

                // aca se pueden sacar atributos de la imegen como 
            };

        var  html_modal ='';

            html_modal += '<div class="modal fade " id="modalCargaGuardaImg" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">';
            html_modal +=   '<div class="modal-dialog modal-fullscreen-xxl-down modal-xl" role="document">';
            html_modal +=       '<div class="modal-content">';
            html_modal +=           '<div class="modal-header">';
            html_modal +=               '<h5 class="modal-title" id="exampleModalLabel">Documento</h5>';
            html_modal +=               '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">x</button>';
            html_modal +=           '</div>';
            html_modal +=           '<div class="modal-body">';
            html_modal +=               "<img src='" + e.target.result +"' width='100%' height='500px'>";
            html_modal +=           '</div>';
            html_modal +=           '<div class="modal-footer">';
            html_modal +=               '<button type="submit" class="btn btn-secondary" data-bs-dismiss="modal" id="no_guarda_imagen"  >No guardar</button>';
            html_modal +=               '<button type="submit" class="btn btn-secondary" data-bs-dismiss="modal" id="guarda_imagen"  onclick="editaImagen('+idform+','+rutas_ajax+')" >guardar</button>';
            html_modal +=          '</div>';
            html_modal +=       '</div>';
            html_modal +=   '</div>';
            html_modal += '</div>';

            $("body").append( html_modal );

            $("#modalCargaGuardaImg").modal("show");

            var myModalEl = document.getElementById('modalCargaGuardaImg');
            myModalEl.addEventListener('hidden.bs.modal', function (event) {
                       
                $("#modalCargaGuardaImg").remove();

            });

            img.src = objectUrl;

        }
        reader.readAsDataURL(input.files[0]);
    }
}




function dataTableSimple(){

    var dataTable = $('.data_table_simple').DataTable({
          "ordering": false,
           aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
     
            responsive: true,
           language: {
               "url": window.location.origin+"/datatable/SpanishDatatable.json",
               "paginate": {
                   "first":       '<i class="fa fa-angle-double-left"></i>',
                   "previous":    '<i class="fa fa-angle-left"></i>',
                   "next":        '<i class="fa fa-angle-right"></i>',
                   "last":        '<i class="fa fa-angle-double-right"></i>'
               },
           }
    });

    return dataTable;

} 

function datatableSearch(arr_select, arr_buttons = ['copy', 'excel', 'pdf', 'colvis']){

        // arr_select array que define que tipo de busqueda es 1 si es de tipo select options
        // arr_buttons se pasa como valor un array con cualquiera de las siguentes valores ['copy', 'excel', 'pdf', 'colvis'] si se pasa  vacio [] , no se muestran los botones
    var myTable = $('.data_table_search').DataTable({ 
            language: {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "thousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
            // lengthMenu: [
            //     [3, 25, 50, 'Todos'],
            // ],
            lengthChange: false,
            buttons: arr_buttons,
            rowCallback: function( row, data, index ) {
              
            },
            initComplete: function () {     

                $('[data-toggle="tooltip"]').tooltip();

            }

        });

 

        myTable.buttons().container().appendTo('#datatable-buttons_wrapper .col-md-6:eq(0)');// agregamos botones de descaga archivos
        $(".dataTables_length select").addClass('form-select form-select-sm');

   

    myTable.columns().flatten()
        .each(function (colID) {

            if(arr_select[colID] == 'select'){ // se agrega un select options a la cabecera (thead)
      
                var mySelectList = $("<select />").addClass("form-select")
                  .appendTo(myTable.column(colID).header()).on("change", function () {
                    myTable.column(colID).search($(this).val()); 
                    // update the changes using draw() method
                    myTable.column(colID).draw();

                    if(myTable.page.info().end <= 3 && myTable.page.info().pages <= 1 ){

                        $('.paging_simple_numbers').hide();

                    }else{

                        $('.paging_simple_numbers').show();

                    }

                  });               

                var arr_options = [];
 
                myTable.column(colID).cache("search").sort()
                  .each(function (param,k) {
                    if(k == 0){
                        arr_options[0] = 0;
                    }else{

                        arr_options[param] = param; // array llave valor apara que no se dupliquen los datos

                    }                
                
                }); 

                for (var mes in arr_options){ // Agregamos los options 
                 
                    var all = '';
                    if(mes == 0){

                        mySelectList.append('<option value="' +  all + '">Todos</option>'); 

                        
                    }else{
                         mySelectList.append(
                                              $('<option value="' +  mes + '">'
                                                +  mes + "</option>")
                                            );            
                    }
                }

                
            }else if(arr_select[colID] == 'text' ){// se agrega un input text a la cabecera (thead)

                $("<input />").addClass("form-control form-control-sm")
                  .appendTo(myTable.column(colID).header()).on("keyup change clear", function () {
                    myTable.column(colID).search($(this).val()); 
                    // update the changes using draw() method
                    myTable.column(colID).draw();

                    if(myTable.page.info().end <= 10 && myTable.page.info().pages <= 1 ){

                        $('.paging_simple_numbers').hide();

                    }else{

                        $('.paging_simple_numbers').show();

                    }

                });
            }

        });

}


// Example starter JavaScript for disabling form submissions if there are invalid fields
(function() {
    'use strict';
    window.addEventListener('load', function() {
        // Fetch all the forms we want to apply custom Bootstrap validation styles to
        var forms = document.getElementsByClassName('needs-validation');
        // Loop over them and prevent submission
        var validation = Array.prototype.filter.call(forms, function(form) {
        form.addEventListener('submit', function(event) {
            if (form.checkValidity() === false) {
            event.preventDefault();
            event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
        });
    }, false);
})();


$(document).ready(function(){

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    }); 

    // parsley validation 
    $('.custom-validation').parsley();

    //modify buttons style  : BOTONES PARA EDICION DIREC>TO EN TABLA
    if ( $('script[src="'+window.location.origin+'/assets/libs/bootstrap-editable/bootstrap-editable.min.js"]').length )  {
 
        $.fn.editableform.buttons =
            '<button type="submit" class="btn btn-success editable-submit btn-sm waves-effect waves-light"><i class="mdi mdi-check"></i></button>' +
            '<button type="button" class="btn btn-danger editable-cancel btn-sm waves-effect waves-light"><i class="mdi mdi-close"></i></button>';

 
    // PAra editar directo un campo desde la tabla se debe hacer de esta forma :
    // <a href="#" data-type="text" data-ruta-ajax="edita_campo_en_tabla" data-id="{{$value->id}}" data-campo="stock_critico">{{$value->stock_critico}}</a>
    $('.edita_campo_en_tabla').editable({
        type: 'file',
        pk: 1,
        name: 'username',
        title: 'Enter username',
        mode: 'inline',
        emptytext:'Vacío',
        inputclass: 'form-control-sm',
        success: function (response, newValue) {
            id = $(this).data('id');
            campo = $(this).data('campo');
            $(this).attr('width',30);
            $.get( $(this).data('ruta-ajax') , {val: newValue ,id:id ,  campo:campo},function(response){

                mensajeRetorno('Campo editado con éxito', 'success', 6000);     

            });
   
        },

    });
    
   }
  


    $('.popup-gallery').magnificPopup({
        delegate: 'a',
        type: 'image',
        tLoading: 'Loading image #%curr%...',
        mainClass: 'mfp-img-mobile',
        gallery: {
          enabled: true,
          navigateByImgClick: true,
          preload: [0, 1] // Will preload 0 - before current, and 1 after the current image

        },
        image: {
          tError: '<a href="%url%">The image #%curr%</a> could not be loaded.'
        }
      });



});