<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUnidadesMedidaRepCablesMedidasDespues extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('informe_cables', function (Blueprint $table) {
            $table->boolean('dispositivo_vlf')->default(0)->after('observacion_reparacion');
            $table->boolean('dispositivo_medidor_aislacion')->default(0)->after('dispositivo_vlf');

            $table->string('unidad_medida_reparacion_f1')->after('f1_medidas_reparacion');
            $table->string('unidad_medida_reparacion_f2')->after('f2_medidas_reparacion');
            $table->string('unidad_medida_reparacion_f3')->after('f3_medidas_reparacion');
            $table->string('unidad_medida_reparacion_hp')->after('hp_medidas_reparacion');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('informe_cables', function (Blueprint $table) {
            $table->dropColumn('dispositivo_vlf');
            $table->dropColumn('dispositivo_medidor_aislacion');
            
            $table->dropColumn('unidad_medida_reparacion_f1');
            $table->dropColumn('unidad_medida_reparacion_f2');
            $table->dropColumn('unidad_medida_reparacion_f3');
            $table->dropColumn('unidad_medida_reparacion_hp');
        });
    }
}
