<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaterialInformeSenialeticasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('material_informe_senialeticas', function (Blueprint $table) {
            $table->id();
            $table->boolean('estado')->default(true);
            $table->integer('cantidad');
            $table->unsignedBigInteger('informe_senialetica_id');
            $table->foreign('informe_senialetica_id')->references('id')->on('informe_senialeticas');

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users');                

            $table->unsignedBigInteger('material_id');
            $table->foreign('material_id')->references('id')->on('materiales');
            $table->timestamps();
            $table->softDeletes();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('material_informe_senialeticas');
    }
}
