<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEvidenciaAntesDespuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('evidencia_antes_despues', function (Blueprint $table) {
            $table->id();
            $table->string('impit_expit');   
            $table->string('descripcion_ubicacion', 50);
            $table->string('imagen_antes', 50)->nullable();
            $table->string('imagen_despues', 50)->nullable();            
            $table->boolean('estado')->default(true);
            $table->unsignedBigInteger('informe_senialetica_id');
            $table->foreign('informe_senialetica_id')->references('id')->on('informe_senialeticas');
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('evidencia_antes_despues');
    }
}
