@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.css') }}" rel="stylesheet"
        type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />


    <style type="text/css"> 

        button:disabled {
            background: #9295a4!important;
        }
    </style>

@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Forms @endslot
        @slot('title') Marcas y Modelos @endslot
    @endcomponent
  

 


<div class="modal fade" id="creaMarca" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                    </div>
                </div>
            </div>
            
            <div class="modal-body">
                <form  id="form_edita_crea" class="custom-validation" action="{{ route('marcas_modelos.store') }}" method="POST">
                @csrf
    
                <input type="hidden" id="edita_marca_id" name="marca_id" value="">
                
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                        
                            <label class="form-label" for="id_name">Nombre</label>
                            <input type="text" class="form-control" id="id_name" required name="nombre">
    
                        </div>
                    </div>
                </div>
            </div>

                <input type="submit" class="btn btn-primary" id="guarda_marca" value="Enviar"> 
    
        </form>

        </div>
    </div>
</div>

<div class="modal fade" id="creaNuevoModelo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" class="btn btn-secondary btn-lg btn-block waves-effect waves-light" data-bs-dismiss="modal">x</button>
                    </div>
                </div>
            </div>
            
            <div class="modal-body">
                {{-- <form  id="form_edita_crea" class="custom-validation" action="{{ route('marcas_modelos.store') }}" method="POST"> --}}
                {{-- @csrf --}}
    
                {{-- <input type="hidden" id="edita_marca_id" name="marca_id" value=""> --}}
                
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                        
                            <label class="form-label" for="id_name">Nombre</label>
                            <input type="text" class="form-control" id="nombre_modelo" required name="nombre">
    
                        </div>

                        <div class="col-md-12">
                        
                            <label class="form-label" for="id_name">Año</label>
                            <input type="number" class="form-control" id="year_modelo" required name="year" min="1960" max="2100">
    
                        </div>

                    </div>
                </div>
            </div>

                {{-- <input type="submit" class="btn btn-primary" id="guarda_marca" value="Enviar">  --}}
                <button class="btn btn-primary"
                    id="btn-crear-modelo" 
                    {{-- data-bs-target="#creaModelo"  --}}
                    {{-- data-bs-toggle="modal"  --}}
                    {{-- data-bs-dismiss="modal" --}}
                >Crear Modelo y Continuar</button>

                <button class="btn btn-warning"
                    data-bs-target="#creaModelo" 
                    data-bs-toggle="modal" 
                    data-bs-dismiss="modal">Salir</button>
        {{-- </form> --}}

        </div>
    </div>
</div>

<div class="modal fade" id="creaModelo" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="row">       
                    <div class="col-md-12 d-grid gap-2">
                        <button type="button" 
                        class="btn btn-secondary btn-lg btn-block waves-effect waves-light" 
                        data-bs-dismiss="modal">x</button>
                    </div>
                </div>
            </div>
            
            <div class="modal-body">
                {{-- <form  id="form_edita_crea" class="custom-validation" action="{{ route('marcas_modelos.store') }}" method="POST">
                @csrf --}}
    
                <input type="hidden" id="modelo_marca_id" name="marca_id" value="">
                
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="btn btn-primary" 
                            data-bs-target="#creaNuevoModelo" 
                            data-bs-toggle="modal" 
                            data-bs-dismiss="modal">Crear Nuevo Modelo</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                        
                            {{-- <label class="form-label" for="id_name">Nombre</label>
                            <input type="text" class="form-control" id="id_name" required name="nombre"> --}}
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">

                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Año</th>
                                            <th>Habilitado</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tabla-modelos">
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

                {{-- <input type="submit" class="btn btn-primary" id="cerrar_modelos" value="Cerrar">  --}}
                <button type="button" 
                        class="btn btn-primary" 
                        data-bs-dismiss="modal">Cerrar</button>
    
        {{-- </form> --}}

        </div>
    </div>
</div>


    {{-- comienza vista principal de marcas y modelos --}}
    <div class="row">       
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">

                    <button type="button" 
                        id="crea" 
                        class="btn btn-primary waves-effect waves-light" 
                        data-bs-toggle="modal" 
                        data-bs-target="#creaMarca">Nuevo</button>

                    <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap data_table_search"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th class="text-center">Editar</th>                                 
                                <th class="text-center">Habilitado</th>  

                            </tr>
                        </thead>


                        <tbody>

                            @if(isset($marcas))
                                @foreach($marcas as $c)
                                <tr>
                                    <td>
                                        {{-- <span id="name_{{$c->id}}">{{$c->nombre}}</span> --}}
                                        <a href="#" 
                                            id="name_{{$c->id}}" 
                                            class="edita_campo_en_tabla" 
                                            data-type="text" 
                                            data-ruta-ajax="/edita_campo_en_tabla_marca_vehiculo" 
                                            data-id="{{$c->id}}" 
                                            data-campo="nombre" 
                                            data-pk="1" 
                                            data-title="Nombre">{{$c->nombre}}</a>

                                    </td>
                                    <td class="text-center">
                                        {{-- <button 
                                            class="btn btn-primary editar"  
                                            data-id="{{$c->id}}" 
                                            @if(!$c->estado) disabled @endif >
                                                Editar Marca
                                        </button>  --}}

                                        <button 
                                            class="btn btn-primary editar-modelos"  
                                            data-id="{{$c->id}}" 
                                            @if(!$c->estado) disabled @endif >
                                                Editar Modelos
                                        </button> 

                                    </td>
                                    <td class="text-center">
                                        <form id="form_estado_{{ $c->id }}" action="{{ route('marcas_modelos.destroy',$c->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            
                                            <input type="hidden" name="marca_id" value="{{ $c->id }}">

                                            <input 
                                                onchange="activoInactivo(this)" 
                                                data-id-form="form_estado_{{ $c->id }}" 
                                                type="checkbox" 
                                                id="estado_{{$c->id}}" 
                                                name="activo_inactivo" 
                                                switch="success" 
                                                @if($c->estado) checked="" @endif 
                                                value="1" 
                                                data-parsley-multiple="enchufe" >

                                            <label 
                                                for="estado_{{$c->id}}" 
                                                data-on-label="si" 
                                                data-off-label="No"></label> 
                                        </form> 
                                    </td>


                                </tr>    
                                @endforeach  
                            @endif
 
                        </tbody> 


                </div>
            </div>
        </div>
    </div><!--end row-->




@endsection
@section('script')
    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>
    <!-- lightbox init js-->

    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>


        <script src="{{ URL::asset('/assets/libs/bootstrap-editable/bootstrap-editable.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/datatables/datatables.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/jszip/jszip.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/pdfmake/pdfmake.min.js') }}"></script>
    
    <script src="{{ URL::asset('/assets/libs/slim-select/slim-select.min.js') }}"></script>
    <link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
    <script>
        
    </script>


    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>




    <script type="text/javascript">

    function  activoInactivo(input){
        $(input).parent().submit();            
    }

    $(document).ready(function(){ 

        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }


        $("#btn-crear-modelo").on('click', function(){
            var idMarca = $("#modelo_marca_id");
            var nombreModelo = $("#nombre_modelo");
            var yearModelo = $("#year_modelo");

            if(nombreModelo.val() == ""){
                alert("Debe ingresar un nombre para continuar");
                return false;
            }

            // if(yearModelo.val() == ""){
            if (!yearModelo.val() || isNaN(yearModelo.val()) || yearModelo.val() < 1900 || yearModelo.val() > 2100) {
                alert("Debe ingresar un año para continuar");
                return false;
            }

            $.ajax({
                url: "/crear_nuevo_modelo",
                dataType: 'json',
                type: 'POST',
                data: {'id_marca': idMarca.val(), 'nombre_modelo': nombreModelo.val(), 'anio': yearModelo.val()}, 
                success: function(result){
                    // console.log("idMarca", idMarca.val());
                    if(result.error == false){
                        $('.editar-modelos[data-id="' + idMarca.val() + '"]').trigger("click");
                        alert(result.mensaje);

                        nombreModelo.val("");
                        yearModelo.val("");

                        $('#creaNuevoModelo').modal('hide');
                        $('#creaModelo').modal('show');
                    }else{
                        alert("Ha ocurrido un error a nivel de servidor. Favor notificar a Soporte.");
                    }
                },
                error: function(error) {
                    console.error(error);
                    alert("Ha ocurrido un error a nivel de servidor. Favor notificar a Soporte.");
                }
            });

        });

        $('#creaMarca').on('hidden.bs.modal', function (e) {
            $(".parsley-errors-list").remove();
            $("#form_edita_crea input,select").removeClass("parsley-error");
            $("#form_edita_crea")[0].reset();
        })


        // $(".editar").click(function(){
        //     var full_nombre = $("#name_"+$(this).data("id")).text().trim();

        //     $("#id_name").val( full_nombre );

        //     $("#creaMarca").modal("show");
     
        //     $("#form_edita_crea").attr("action","/marcas_modelos/"+$(this).data('id'));
        //     $("#form_edita_crea").append("<input name='_method' type='hidden' value='PUT' id='put'>");
     
        //     $("#edita_marca_id").val($(this).data('id'));
        // });

        $(".editar-modelos").click(function(){

            // $("#creaModelo").modal("show");
            var idMarca = $(this).data('id');
            $("#modelo_marca_id").val(idMarca);
            $("#tabla-modelos").html("");

            $.ajax({
                url: "/modelos_por_marca",
                dataType: 'json',
                type: 'POST',
                data: {'id_marca': idMarca}, 
                success: function(result){
                    // console.log(result);
                    if(result.error == false){
                        // Agregar una opción por cada modelo obtenido
                        $.each(result.modelos, function(index, modelo) {
                            var checked = "";
                            if(modelo.estado == 1){
                                checked = 'checked="" ';
                            }

                            var year = "-";
                            if(modelo.anio != null){
                                year = modelo.anio;
                            }
                            var html = '<tr>' +
                                // '<td scope="row">' + modelo.nombre + '</td>' +
                                '<td scope="row"><a href="#" ' +
                                '    id="nombre_modelo_' + modelo.id + '" ' +
                                '    class="edita_campo_en_tabla" ' +
                                '    data-type="text" ' +
                                '    data-id="' + modelo.id + '" ' +
                                '    data-campo="nombre" ' +
                                '    data-pk="1" ' +
                                '    data-ruta-ajax="/edita_campo_en_tabla_modelo"' +
                                '    data-title="Nombre">' + modelo.nombre + '</a></td>' +
                                // '<td scope="row">' + year + '</td>' +
                                '<td scope="row"><a href="#" ' +
                                '    id="anio_modelo_' + modelo.id + '" ' +
                                '    class="edita_campo_en_tabla" ' +
                                '    data-type="text" ' +
                                '    data-id="' + modelo.id + '" ' +
                                '    data-campo="anio" ' +
                                '    data-pk="1" ' +
                                '    data-ruta-ajax="/edita_campo_en_tabla_modelo"' +
                                '    data-title="Año">' + year + '</a></td>' +

                                '<td>' +
                                    '<form class="form_estado_modelo" data-id-modelo="' + modelo.id + '" action="/cambia_estado_modelo" method="POST">'+
                                        '@csrf'+
                                        
                                        '<input type="hidden" name="modelo_id" value="' + modelo.id + '">'+

                                        '<input ' +
                                            'onchange="activoInactivo(this)" ' +
                                            'data-id-form="form_estado_modelo_' + modelo.id + '" '+
                                            'type="checkbox" '+
                                            'id="estado_modelo_' + modelo.id + '" '+
                                            'name="activo_inactivo" '+
                                            'switch="success" '+
                                            checked +
                                            'value="1" '+
                                            'data-parsley-multiple="enchufe" >'+

                                        '<label '+
                                            'for="estado_modelo_' + modelo.id + '" '+
                                            'data-on-label="si" '+
                                            'data-off-label="No"></label> '+
                                    '</form> '+
                                '</td>' +
                            '</tr>';
                            // selectModelos.append('<option value="' + modelo.id + '">' + modelo.nombre + '</option>');
                            $("#tabla-modelos").append(html);
                        });

                        $("#creaModelo").modal("show");

                    }
                },
                error: function(error) {
                    console.error(error);
                    alert("Ha ocurrido un error a nivel de servidor. Favor notificar a Soporte.");
                }
            });

        });

        $("#crea").click(function(){

            $("#form #put").remove();
            $("#form").attr("action","/marcas_modelos");  
        });

        datatableSearch(['text'],['excel', 'pdf']);

        $(".select2").select2(); 
        
        $('.edita_campo_select').each(function() {
            var $a = $(this);
            $a.editable({
                mode: 'inline',
                inputclass: 'form-select form-select-sm',
                value: $a.data('pk'), // Establecer el valor por defecto como data-pk
                source: OpcionesSelectCategorias,
                success: function (response, newValue) {
                    var id = $a.data('id');
                    var campo = $a.data('campo');
                    $a.attr('width', 30);
                    $.get('/edita_campo_en_tabla_marca_vehiculo', {val: newValue, id: id, campo: campo}, function(response) {
                        mensajeRetorno('Campo editado con éxito', 'success', 6000);
                    });
                },
            });
        });
        

        $(document).on('submit', ".form_estado_modelo", function(e){
            // alert($(this).prop("action"));
            // return false;
            e.preventDefault();

            // Obtener los datos del formulario
            var formData = $(this).serialize();

            // Enviar los datos utilizando AJAX
            $.ajax({
                type: 'POST', // Método HTTP (puede ser POST o GET, dependiendo de tu configuración)
                // url: 'tu_archivo_php_para_procesar_formulario.php', // URL donde enviar los datos
                url: $(this).prop("action"), // URL donde enviar los datos
                data: formData, // Datos a enviar, en este caso, los datos del formulario serializados
                dataType: "json",
                success: function(response) {
                    if(response.error == false){
                        alert(response.mensaje);
                    }
                    else{
                        alert("Error al momento de cambiar el estado del modelo. Favor contactar con Soporte");
                    }
                },
                error: function(error) {
                    // Manejar errores en caso de que falle la solicitud AJAX
                    console.error('Error al enviar la solicitud:', error);
                    // Aquí puedes mostrar un mensaje de error al usuario
                    alert(error);
                }
            });
        });

    });
        



    </script>
@endsection

@section('css')
<link rel="stylesheet" href="{{URL::asset('/assets/libs/slim-select/slim-select.min.css')}}">
@endsection

