@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
    <link href="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('/assets/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <style type="text/css">
        #parsley-id-multiple-informe{
            width: 200px!important;
        }
        .parsley-errors-list{
            width: 200px!important;
        }
    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Informes @endslot
        @slot('title') Informes @endslot
    @endcomponent
 
<!------->

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="card-title">INFORMES</h4>
                    <p class="card-title-desc"></p>
                    <form action="/resultado_busca_informes"  class="custom-validation" >
                    <div class="row">         
                        <div class="col-lg-4">
                      
                            <input class="form-check-input" type="radio" id="tipo_informe_cables" name="tipo_informe" value="cables" {{ $checked_cable }} required>
                            <label class="form-check-label" for="tipo_informe_cables">
                                Informe Cables
                            </label>                               
                  
                        </div>
                        <div class="col-lg-4">
                            <input class="form-check-input" type="radio" id="tipo_informe_senaletica" name="tipo_informe" value="senialetica" {{ $checked_senialetica }}  required>
                            <label class="form-check-label" for="tipo_informe_senaletica">
                                Informe Señaleticas
                            </label>
                        </div> 
                    </div>
                    <br>
                    <div class="row" style="margin-bottom: 50px;">
                        <div class="col-md-2">                      
                            <input type="text" name="trabajador" class="form-control" id="rut_user" value="{{ $trabajador }}"  placeholder="Rut trabajador"  required>               
                        </div>

                        <div class="col-lg-6">
                   
                             <div class="input-daterange input-group" id="datepicker6" data-date-format="yyyy-mm-dd"
                                data-date-autoclose="true" data-provide="datepicker"
                                data-date-container='#datepicker6'>
                                <input type="text" class="form-control" name="fecha_inicio" value="{{$fecha_inicio}}" placeholder="Fecha inicio" required  autocomplete="off"/>
                                <input type="text" class="form-control" name="fecha_fin" value="{{$fecha_fin}}"  placeholder="Fecha fin" required  autocomplete="off"/>
                            </div>
                  
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <button class="btn btn-primary" type="submit" id="busca_user">Buscar</button>  
                        </div> 

                    </div> 
                    </form>
                </div>
            </div>
        </div>
    </div> <br><br><br>
<!-- end row --> 
@if($user)
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Antecedentes del tecnico reparaciones</h4>
                <div class="row">
                    <div class="col-md-3">                      
                        <span>Nombre: </span><span id="nombre_tecnico">{{ $user->nombre }} {{ $user->apellido_paterno }} {{ $user->apellido_materno }}</span>         
                    </div>                 
                    <div class="col-md-2">
                        <span>Rut: </span><span id="rut_tecnico">{{ $user->rut }}</span>   
                    </div>
                    <div class="col-md-3">
                        <span>Empresa: </span><span id="empresa_tecnico">{{ $user->Empresa->nombre }}</span>   
                    </div>        
                    <div class="col-md-4">
                        <span>Email: </span><span id="email_tecnico">{{ $user->email }}</span>   
                    </div>  
                </div>
            </div>
        </div>
        <!-- end card -->
    </div> <!-- end col -->
</div>
@endif

<div class="row" id="materiales_entrega" style="">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">Informes {{ $categoria }}</h4>
                <div class="row">
                    @if($informes)

                    @foreach($informes as $key => $value)
                        <div class="col-lg-2">
                            <div class="card" style="border: solid 3px #22252f;"  
                            onclick="verDocumento('/detalle_informe?id={{ $value->id }}&tipo={{ $tipo_informe }}&nom_tecnico={{ $user->nombre .' ' . $user->apellido_paterno . ' ' . $user->apellido_materno }}&empresa_tecnico={{ $user->Empresa->nombre }}&rut_tecnico={{ $user->rut }}&email_tecnico={{ $user->email }}')">    
                                <div class="card-body">
                                    <h5 class="card-title">Informe N° {{ $value->id }}</h5>
                                    <div class="row g-0 align-items-center"> 
                                        <div class="card-text">{{ $value->created_at }}</div>
                                    </div>
                                </div>                                 
                            </div>
                            <form action="/notify_centinela/{{ $value->id }}?id={{ $value->id }}&tipo={{ $tipo_informe }}&nom_tecnico={{ $user->nombre }} {{ $user->apellido_paterno }} {{ $user->apellido_materno }}&empresa_tecnico={{ $user->Empresa->nombre }}&rut_tecnico={{ $user->rut }}&email_tecnico={{ $user->email }}&fecha_inicio={{$fecha_inicio}}&fecha_fin={{$fecha_fin}}" method="POST">
                            @csrf
                                <div class="col-md text-center mb-2">
                                <button class="btn btn-outline-success" type="submit" id="notify_centinela">Notificar a MCEN</button>
                                </div>
                            </form>
                        </div>
                    @endforeach
                </div>
                {!! $informes->appends($_GET)->links() !!}
                @else
                    Sin Resultados
                @endif
            </div>
        </div>
    </div>        
</div>        

@endsection
@section('script')

    <script src="{{ URL::asset('/assets/libs/parsleyjs/parsleyjs.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/parsleyjs/es.js') }}"></script>

    <!-- Magnific Popup-->
    <script src="{{ URL::asset('/assets/libs/magnific-popup/magnific-popup.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/libs/sweetalert2/sweetalert2.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/select2/select2.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/jquery.Rut.js')}}"></script>


    
    <script src="{{ URL::asset('/assets/libs/bootstrap-datepicker/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/bootstrap-touchspin/bootstrap-touchspin.min.js') }}"></script>
    <script src="{{ URL::asset('/assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js') }}"></script>

    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>


    <script type="text/javascript">

    function removeTema(val){

        $(".carga_tema_"+val).remove();
    }

    function buscaUser(rut){  

        var rut_user = $("#rut_user").val();

        $.get("selectusuario?rut_user="+rut_user,function(response){

            $("#materiales_entrega").hide();

            if( typeof response != 'string'){

                if(!response[1].length){

                    alert('Trabajador sin materiales');
                    return;
                    
                }
                cargaResponsable(response);

            }else{
                $("#exampleModal").modal('show');
                $("#recipient-rut").val(response);
            }

        });        

    }

    function verDocumento( ruta_documento ,  ruta_origen = null){

        if(  ruta_origen == 'window_location_origin' ){

            ruta_documento = window.location.origin+ruta_documento;


        } else if(ruta_origen){
            
            ruta_documento = ruta_origen + ruta_documento;
        }

        ruta_documento = ruta_documento.replace(' ','');
     
        typo_archivo = ruta_documento.split('.').pop();

        var buscarOffice = ["doc", "docx", "xls", "xlsx", "ppt", "pptx", "ocx"];

        var office = "https://view.officeapps.live.com/op/embed.aspx?src=";

        if(buscarOffice.includes(typo_archivo)){

            ruta_documento = office + ruta_documento;
        }

        var  html_modal ='';

        html_modal += '<div class="modal fade " id="modal_documentos" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">';
        html_modal +=   '<div class="modal-dialog modal-fullscreen-xxl-down modal-xl" role="document">';
        html_modal +=       '<div class="modal-content">';
        html_modal +=           '<div class="modal-header">';
        html_modal +=               '<h5 class="modal-title" id="exampleModalLabel">Documento</h5>';
        html_modal +=               '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">x</button>';
        html_modal +=           '</div>';
        html_modal +=           '<div class="modal-body">';
        html_modal +=               "<iframe src='" + ruta_documento +"' width='100%' height='500px'> </iframe>";
        html_modal +=           '</div>';
        html_modal +=           '<div class="modal-footer">';
        html_modal +=          '</div>';
        html_modal +=       '</div>';
        html_modal +=   '</div>';
        html_modal += '</div>';

        $("body").append( html_modal );

        $("#modal_documentos").modal("show");

        var myModalEl = document.getElementById('modal_documentos');
        myModalEl.addEventListener('hidden.bs.modal', function (event) {
                   
            $("#modal_documentos").remove();

        });       

    }

    $('#rut_user').Rut({
        format_on: 'keyup'             
    });

    $(document).ready(function(){
        
        var success =  @json(Session::get('success'));

        if(success){
            mensajeRetorno(success, 'success', 6000);  
        }
        $(".select2").select2();

    });

    </script>
@endsection
