@extends('layouts.master')
@section('title')
    @lang('translation.Validation')
@endsection
@section('css')
    <!-- Lightbox css -->
 
    <style type="text/css">
        
    #container {
      height: 400px;
      min-width: 360px; 
      max-width: 800px;
      margin: 0 auto;
    }

    </style>
@endsection
@section('content')
    @component('common-components.breadcrumb')
        @slot('pagetitle') Materiales @endslot
        @slot('title') Entrega de Materiales @endslot
    @endcomponent 

<!-- Flag sprites service provided by Martijn Lafeber,
    https://github.com/lafeber/world-flags-sprite/blob/master/LICENSE -->
<link rel="stylesheet" type="text/css"
      href="https://github.s3.amazonaws.com/downloads/lafeber/world-flags-sprite/flags32.css" />

<div class='buttons'>
  <button id='2000'>
    2000
  </button>
  <button id='2004'>
    2004
  </button>
  <button id='2008'>
    2008
  </button>
  <button id='2012'>
    2012
  </button>
  <button id='2016'>
    2016
  </button>
  <button id='2020' class='active'>
    2020
  </button>
</div>
<div id="container"></div>


<div class="modal fade bd-example-modal-lg" id="carga_grafico" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      ...
    </div>
  </div>
</div>
@endsection
@section('script')

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script src="https://code.highcharts.com/stock/highstock.js"></script>
<script src="https://code.highcharts.com/stock/modules/data.js"></script>
<script src="https://code.highcharts.com/stock/modules/exporting.js"></script>
<script src="https://code.highcharts.com/stock/modules/export-data.js"></script>
<script src="https://code.highcharts.com/stock/modules/accessibility.js"></script>



    <script src="{{ URL::asset('/assets/js/funcionesGlobales.min.js')}}"></script>

    <script type="text/javascript">

 

        $(document).ready(function(){


 
const countries = [{
    name: 'Lunes',
    y: 5,
    color: '#898fa9'
}, {
    name: 'Martes',
    y: 6,
    color: '#898fa9'
}, {
    name: 'Miercoles',
    y: 30,
    color: '#898fa9'
}, {
    name: 'Jueves',
    y: 44,
    color: '#898fa9'
}, {
    name: 'Viernes',
    y: 66,
    color: '#898fa9'
}, {
    name: 'Sabado',
    y: 50,
    color: '#898fa9'
}, {
    name: 'Domingo',
    y: 30,
    color: '#898fa9'
}];

const countries2 = [{
    name: 'Lunes',
    y:4,
    color: 'rgb(201, 36, 39)'
}, {
    name: 'Martes',
    y:12,
    color: 'rgb(201, 36, 39)'
}, {
    name: 'Miercoles',
    y: 88,
    color: 'rgb(0, 82, 180)'
}, {
    name: 'Jueves',
    y: 88,
    color: 'rgb(0, 0, 0)'
}, {
    name: 'Viernes',
    y: 66,
    color: 'rgb(240, 240, 240)'
}, {
    name: 'Sabado',
    y: 58,
    color: 'rgb(255, 217, 68)'
}, {
    name: 'Domingo',
    y: 20,
    color: 'rgb(0, 82, 180)'
}];
 
 
const chart = Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Materiales',
        align: 'left'
    },
    subtitle: {
        text: 'Comparing to results from Summer Olympics 2016 - Source: <a ' +
            'href="https://olympics.com/en/olympic-games/tokyo-2020/medals"' +
            'target="_blank">Olympics</a>',
        align: 'left'
    },
    plotOptions: {
        column: {
            grouping: false,
            shadow: false,
            borderWidth: 0
        },series: {
         cursor: 'pointer',
         point: {
             events: {
                click: function() {
                   // alert ('Category: '+ this.category +', value: '+ this.y);

                   $("#carga_grafico").modal('show'); 
                }
            }
        }
    }
    },
    legend: {
        enabled: false
    },
    tooltip: {
        shared: true,
        headerFormat: '<span style="font-size: 15px">{point.point.name}</span><br/>',
        pointFormat: '<span style="color:{point.color}">\u25CF</span> {series.name}: <b>{point.y} medals</b><br/>'
    },
    xAxis: {
        type: 'category',
        accessibility: {
            description: 'Countries'
        },
        max: 6,
        labels: {
            useHTML: true,
            animate: true,
            // formatter: ctx => {
            //     let flag;

            //     countries.forEach(function (country) {
            //         if (country.name === ctx.value) {
            //             flag = country.flag;
            //         }
            //     });

            //     return `${flag.toUpperCase()}<br>`;
            // },
            // style: {
            //     textAlign: 'center'
            // }
        }
    },
    yAxis: [{
        title: {
            text: 'Gold medals'
        },
        showFirstLabel: false
    }],
    series: [{
        color: 'rgb(158, 159, 163)',
        pointPlacement: -0.2,
        linkedTo: 'main',
        data: countries2, 
        name: '2016'
    }, {
        name: '2020',
        id: 'main',
        dataSorting: {
            enabled: true,
            matchByName: true
        },
        dataLabels: [{
            enabled: true,
            inside: true,
            style: {
                fontSize: '16px'
            }
        }],
        data: countries
    }],
    exporting: {
        allowHTML: true
    }
});

// const locations = [
//     {
//         city: 'Lunes',
//         year: 2020
//     }, {
//         city: 'Rio',
//         year: 2016
//     }, {
//         city: 'London',
//         year: 2012
//     }, {
//         city: 'Beijing',
//         year: 2008
//     }, {
//         city: 'Athens',
//         year: 2004
//     }, {
//         city: 'Sydney',
//         year: 2000
//     }
// ];

// locations.forEach(location => {
//     const btn = document.getElementById(location.year);

//     btn.addEventListener('click', () => {

//         document.querySelectorAll('.buttons button.active')
//             .forEach(active => {
//                 active.className = '';
//             });
//         btn.className = 'active';

//         chart.update({
//             title: {
//                 text: 'Summer Olympics ' + location.year +
//                     ' - Top 5 countries by Gold medals'
//             },
//             subtitle: {
//                 text: 'Comparing to results from Summer Olympics ' +
//                     (location.year - 4) + ' - Source: <a href="https://olympics.com/en/olympic-games/' +
//                     (location.city.toLowerCase()) + '-' + (location.year) + '/medals" target="_blank">Olympics</a>'
//             },
//             series: [{
//                 name: location.year - 4,
//                 data: dataPrev[location.year].slice()
//             }, {
//                 name: location,
//                 data: getData(data[location.year]).slice()
//             }]
//         }, true, false, {
//             duration: 800
//         });
//     });
// });

            



})

    </script>
@endsection
