<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevolucionMaterialesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('devolucion_materiales', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('material_id');
            $table->foreign('material_id')->references('id')->on('materiales');

            $table->unsignedBigInteger('user_entrega_id');
            $table->foreign('user_entrega_id')->references('id')->on('users');

            $table->unsignedBigInteger('user_recibe_id');
            $table->foreign('user_recibe_id')->references('id')->on('users');

            $table->integer('cantidad');
            $table->boolean('estado')->default(true);        

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('devolucion_materiales');
    }
}
