<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaterialInformeCablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('material_informe_cables')){

            Schema::create('material_informe_cables', function (Blueprint $table) {
                $table->id();
                $table->boolean('estado')->default(true);
                $table->integer('cantidad');
                $table->unsignedBigInteger('informe_cable_id');
                $table->foreign('informe_cable_id')->references('id')->on('informe_cables');

                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on('users');                

                $table->unsignedBigInteger('material_id');
                $table->foreign('material_id')->references('id')->on('materiales');
                $table->timestamps();
                $table->softDeletes();

            });

        }else{
            echo "Ya existe la tabla material_informe_cables\n";
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('material_informe_cables');
    }
}
