<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInformeCablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            
        if(!Schema::hasTable('informe_cables')){

            Schema::create('informe_cables', function (Blueprint $table) {

                $table->id();
                $table->string('ubicacion')->nullable();

                $table->unsignedBigInteger('empresa_id');
                $table->foreign('empresa_id')->references('id')->on('empresas');

                $table->unsignedBigInteger('user_id');
                $table->foreign('user_id')->references('id')->on('users');


                $table->string('numero_cable')->nullable();


                $table->boolean('enchufe')->default(0);
                $table->string('fabricante', 50)->nullable();
                $table->string('calibre', 50)->nullable();
                $table->string('falla', 50)->nullable();

                $table->string('clase_aislacion', 50)->nullable();
                $table->integer('longitud')->nullable();
                $table->string('mufas', 50)->nullable();

                $table->boolean('f1_medidas_ingreso')->default(0);
                $table->boolean('f2_medidas_ingreso')->default(0);
                $table->boolean('f3_medidas_ingreso')->default(0);
                $table->boolean('hp_medidas_ingreso')->default(0);

                $table->string('observacion_ingreso', 50)->nullable();


                $table->boolean('cortes_metros')->default(0);
                $table->string('cantidad_metros', 50)->nullable();
                $table->string('cantidad_mufas', 50)->nullable();
                $table->string('nueva_cantidad_mufas', 50)->nullable();

                $table->string('observacion_reparacion', 50)->nullable();

                $table->string('f1_medidas_reparacion')->default(0);
                $table->string('f2_medidas_reparacion')->default(0);
                $table->string('f3_medidas_reparacion')->default(0);
                $table->string('hp_medidas_reparacion')->default(0);

                $table->string('observacion_general_final', 50)->nullable();

                $table->boolean('continuidad_fase')->default(0);
                $table->boolean('continuidad_hp')->default(0);

                $table->timestamps();
                $table->softDeletes();
                
            });

        }else{
            echo "Ya existe la tabla checklist_repara_cable\n";
        }




    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('informe_cables');
    }
}
