<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
// use App\Models\City;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('nombre', 200);
            $table->string('apellido_paterno', 200);
            $table->string('apellido_materno', 200);

            $table->string('rut', 15)->unique();

            $table->bigInteger('fono')->nullable();
            $table->string('email', 200)->unique();
            $table->timestamp('email_verified_at')->nullable();
  
            $table->string('password');
            $table->unsignedBigInteger('empresa_id')->nullable()->constrained();
            $table->foreign('empresa_id')->references('id')->on('empresas');

            $table->boolean('estado')->default(true);


            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
