<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class MaterialesEntregados extends Model {
    protected $fillable = [
        'estado',
        'cantidad',
        'material_id',
        'user_entrega_id',
        'user_recibe_id', 
        'venta_id',
        'valor',
    ];

    protected $table = 'materiales_entregados';

    public function Material(){
        return $this->hasOne(Materiales::class, 'id', 'material_id');
    }

    public function UserRecibe(){
        return $this->hasOne('App\Models\Usuarios\User', 'id', 'user_recibe_id');
    }

    public function UserEntrega(){
        return $this->hasOne('App\Models\Usuarios\User', 'id', 'user_entrega_id');
    }

    public static function SumEntrega($categoria_material_id = null){
        
        return MaterialesEntregados::whereHas('Material', function($q) use ($categoria_material_id) {
             
                $q->when($categoria_material_id, function($q) use ($categoria_material_id) {

                      $q->where('categoria_material_id', $categoria_material_id);

                }); 

            })->with(['Material' => function ($q){
                    $q->selectRaw("id, nombre");
             }])->groupBy('material_id','created_at')
           ->selectRaw('material_id ,sum(cantidad) as y , DATE_FORMAT(created_at,"%Y-%m-%d") as fecha')//->where('user_recibe_id','=', 3 )
           ->get();
    }
 
    public function getDiaMesAnioAttribute(){

        return Carbon::createFromFormat('d/m/Y', $this->created_at);;

    }



 
}