<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class InformeSenialetica extends Model {
    protected $fillable = [
        'id',
        'doc_especificacion_tecnica',
        'doc_planos',
        'doc_otros',
        'user_id',
        'observacion',
        'empresa_id',
    ];
    
    protected $table = 'informe_senialeticas';

    public function User(){
        return $this->hasOne('App\Models\Usuarios\User', 'id', 'user_id');
    }
    
    public function Empresa(){
        return $this->hasOne(Empresa::class, 'id', 'empresa_id');
    }
    public function MaterialInformeSenialetica(){
        return $this->hasMany(MaterialInformeSenialetica::class,'informe_senialetica_id', 'id');
    }

}