<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class DevolucionMateriales extends Model {
    protected $fillable = [
        'id',
        'estado',
        'cantidad',
        'material_id',
        'user_entrega_id',
        'user_recibe_id',
    ];
   
    protected $table = 'devolucion_materiales';

    public function Material(){
        return $this->hasOne(Materiales::class,  'id', 'material_id');
    }

    public static function SumDevolucion($categoria_material_id = null){
        $categoria_material_id = $categoria_material_id ? $categoria_material_id : null;

        return   DevolucionMateriales::whereHas('Material', function($q) use ($categoria_material_id) {
                 
                $q->when($categoria_material_id, function($q) use ($categoria_material_id) {

                      $q->where('categoria_material_id', $categoria_material_id);

                }); 

            })->with(['Material' => function ($q){
                    $q->selectRaw("id, nombre");
             }])->groupBy('material_id')
           ->selectRaw('material_id ,sum(cantidad) as y',)//->where('user_recibe_id','=', 3 )
           ->get();

    } 
}