<?php

namespace App\Http\Traits;

use  DB;
use  Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\File; 
use Image;

use App\Models\MaterialesEntregados;
use App\Models\DevolucionMateriales;



trait MetodosGlobales {


    public function guardaImagen( $image , $ruta_img, $ruta_thumbnail ){

        $nombre_archivo = substr(str_replace("0.","",microtime()),0,4).'.'.$image->getClientOriginalExtension();
  
        $destinationPath = storage_path($ruta_img);

        if (!File::exists($destinationPath)) {
 
            File::makeDirectory($destinationPath,0777,true);
        }

        $img = Image::make($image->getRealPath());
        $img->resize(null, 800, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath.'/'.$nombre_archivo);

        $destinationPath = storage_path($ruta_thumbnail);

        if (!File::exists($destinationPath)) {
 
            File::makeDirectory($destinationPath,0777,true);
        }


        $img = Image::make($image->getRealPath());
        $img->resize(100, 100, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath.'/'.$nombre_archivo);

        return  $nombre_archivo;
    }
    public function enviaEmail($temple , $arrEnvioEmail , $email , $subject, $archivoAdjunto ){

        Mail::send( $temple  , $arrEnvioEmail , function($message) use ( $email , $subject , $archivoAdjunto ) {

            $message->to($email);
            $message->subject($subject);
            if( $archivoAdjunto ){
                $message->attachData($archivoAdjunto->output(), 'Archivo_' . date("d_m_Y") . '.pdf');   
            }

        });
    }

}