<?php

namespace App\Http\Controllers\Repuestos;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;

use App\Models\Materiales;

use App\Models\MaterialDestinado;
use App\Models\MaterialesEntregados;
use App\Models\AumentoStock;
use App\Models\DevolucionMateriales;

use App\Models\Usuarios\User;
use App\Models\Empresa;

use App\Http\Traits\MetodosGlobales;
use App\Models\CategoriaMateriales;
use App\Models\MaterialInformeCable;
use App\Models\ChecklistReparaCable;
use App\Models\InformeSenialetica;
use App\Models\MarcaVehiculo;
use App\Models\ModeloVehiculo;
use App\Models\Ventas;
use App\Models\Bodega;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;


class RepuestosController extends Controller
{
    
    use MetodosGlobales;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function Materiales(Request $request, $bodega_id)
    {
        // dd($id_bodega);
        $materiales = Materiales::with('CategoriaMateriales')
            // ->where("estado", "=", 1)
            ->where("bodega_id", "=", $bodega_id)
            ->orderBy('id','desc')
            ->get();
        // $empresas = Empresa::all();
        // $users = User::where("estado", "=", 1)->get();
        $categorias = CategoriaMateriales::where("estado", "=", 1)->orderBy("nombre")->get();
        $marcas = MarcaVehiculo::where("estado", "=", 1)->orderBy("nombre")->get();
                
        return view('materiales',compact(
            'materiales',
            // 'users', 
            'categorias', 
            'bodega_id',
            'marcas'
        ));

    }

    public function EntregaMateriales(Request $request)
    {
        // dd($request->path());

        // if (view()->exists($request->path())) { 
            $materiales = Materiales::where("estado", "=", 1)
                ->orderBy('nombre')
                ->get();

            // $empresas = Empresa::all();

            return view('ventas.index',compact('materiales'));
        // }
        // return abort(404);
    }


    // public function root(Request $request)
    // { 
    //     $materiales = Materiales::all();
    //     $empresas = Empresa::all();
    //     $origen = config('constants.origen_material');
    //     return view('index',compact('materiales','empresas','origen'));
        
    // }

    public function MaterialesEntregados(Request $request)
    {  
        // dd($request->all());
        
        $venta = new Ventas;
        // $venta->cliente_user_id = $request->input('user_recibe_id');
        $venta->vendendor_user_id = $request->input('user_entrega_id');
        $venta->bodega_id = $request->input('bodega_id');
        $venta->subtotal_venta = 0;
        $venta->total_venta = 0;
        $venta->save();

        $arr_bajo_stock = [];
        foreach ($request->input('materiales') as $key => $value) {
            $material = Materiales::find($value['material']);

            $venta->subtotal_venta += (intval($material->valor) * intval($value['cantidad']));

            MaterialesEntregados::create( [ 
                'venta_id' => $venta->id,
                'material_id' => $value['material'], 
                'cantidad' => intval($value['cantidad']) ,
                'valor' => intval($material->valor),
                // 'user_recibe_id' => $request->input('user_recibe_id') ,
                'user_entrega_id' => $request->input('user_entrega_id') ,
            ]  );

            // $stock = Materiales::where('id', '=', $value['material'])->select('stock','stock_critico')->first();
 
            Materiales::where('id', '=', $value['material'])
                ->update(['stock' => intval($material->stock) - intval($value['cantidad']) ]);
            
            if( ( intval($material->stock) - intval($value['cantidad']) ) < intval($material->stock_critico) ){

                $arr_bajo_stock[$value['material']]['material']  = $value['nom_material'] ;
                $arr_bajo_stock[$value['material']]['codigo'] = $material->codigo;
                $arr_bajo_stock[$value['material']]['quedan']  = intval($material->stock) - intval($value['cantidad']) ;
            }

        }

        $descuento = 0;
        if($request->has("descuento") && !empty($request->input("descuento"))){
            $descuento = intval($request->input("descuento"));
        }

        $venta->descuento = $descuento;
        $venta->total_venta = $venta->subtotal_venta - $descuento;

        $venta->save();

        if(count($arr_bajo_stock)){

            $email = Auth::user()->email;
            $subject = 'Reporte Bajo Stock';
       
            $this->enviaEmail('mails.falta_stock_email', ['arr_bajo_stock' => $arr_bajo_stock] , $email , $subject, 0 );
            
        }
  
        return  redirect()->action([RepuestosController::class, 'EntregaMateriales'])
                    ->with('success','Venta realizada con éxito');     
 
    }

    public function CreaMaterial(Request $request){
 
       if($request->hasFile("image")){

            $ruta_img = 'app/assets/images/materiales/images';
            $ruta_thumbnail = 'app/assets/images/materiales/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("image"),  $ruta_img , $ruta_thumbnail);
            $request->request->add(['imagen' => $nombre_archivo]);

        } 

        Materiales::create($request->all());

        // return  redirect()->action([MaterialesController::class, 'Materiales'])
        //             ->with('success','Material creado con éxito');
        return redirect()->action([RepuestosController::class, 'Materiales'], ['bodega_id' => $request->input("bodega_id")])
                    ->with('success', 'Material creado con éxito');

    } 

    public function CargaMaterial(Request $request){
        
        return Materiales::with("CategoriaMateriales")
            ->with("Marca")
            ->with("Modelo")
            ->where('id', '=', $request->input('id'))
            ->where("estado", "=", 1)
            ->first();

    }

    //deprecated
    public function DevolverMaterial(Request $request)
    {
 
        foreach ($request->input('material') as $key => $value) {
            DevolucionMateriales::create( [                                         
                                            'cantidad' => $value['cantidad'],
                                            'material_id' => $key,
                                            'user_entrega_id' => $request->input('user_entrega_id'),
                                            'user_recibe_id' => Auth::user()->id ]  );

            $stock = Materiales::where('id', '=', $key)->select('stock')->first();
            Materiales::where('id', '=', $key)->update(['stock' => $stock->stock + $value['cantidad'] ]);

        }

        return  redirect()->action([RepuestosController::class, 'DevolucionMateriales'])
                    ->with('success','Materiales devueltos con éxito');
 
    }

    //deprecated
    public function DevolucionMateriales(Request $request)
    {
        $materiales = Materiales::all();
        $empresas = Empresa::all();
        $user = User::all();

        return view('devolucion_material',compact('materiales','empresas','user'));
        
    }

    
    public function EditaImg(Request $request){

        if($request->hasFile("imagen_material")){

            $ruta_img = 'app/assets/images/materiales/images';
            $ruta_thumbnail = 'app/assets/images/materiales/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("imagen_material"),  $ruta_img , $ruta_thumbnail);
            $request->request->add(['imagen' => $nombre_archivo]);

        }

        $retorno = Materiales::where('id', '=', $request->input('id'))->update(['imagen' => $nombre_archivo ]);

        // return ['id' => $request->input('id') , 'imagen' => $nombre_archivo , 'nombre' => $request->input('nombre') ];       
        // return  redirect()->action([MaterialesController::class, 'Materiales'])
        return redirect()->action([RepuestosController::class, 'Materiales'], ['bodega_id' => $request->input("bodega_id")])
                    ->with('success','Imagen cargada con exito');

    }

    public function EditaCampoEnTabla(Request $request){

        Materiales::where('id', '=', $request->input('id'))->update([ $request->input('campo') => $request->input('val')]); 
        return ['val' => $request->input('val') , 'id' => $request->input('id') ];

    }

    public function AumentoStock(Request $request){

        if($request->hasFile("document")){

            $ruta_img = 'app/assets/images/aumento_stock/images';
            $ruta_thumbnail = 'app/assets/images/aumento_stock/thumbnail';

            $nombre_archivo =  $this->guardaImagen($request->file("document"),  $ruta_img , $ruta_thumbnail);
            $request->request->add(['documento' => $nombre_archivo]);

        }


        $stock = Materiales::where('id', '=',  $request->input('material_id'))
            ->select('stock')
            ->first();

        Log::info('AumentoStock', [
            "material_id" => $request->input("material_id"),
            "stock" => intval($stock->stock),
            "cantidad" => intval($request->input("cantidad")),
            "totalStock" => intval($stock->stock) + intval($request->input('cantidad'))
        ]);


        $totalStock = intval($stock->stock) + intval($request->input('cantidad'));

        Materiales::where('id', '=', $request->input('material_id'))
            ->update([ 'stock' =>  $totalStock]);

        AumentoStock::create($request->all());

        // return  redirect()->action([MaterialesController::class, 'Materiales'])
        return redirect()->action([RepuestosController::class, 'Materiales'], ['bodega_id' => $request->input("bodega_id")])
                ->with('success','Stock aumentado con éxito');

    }

    public function ModelosPorMarca(Request $request){
        // Obtener el valor de id_marca desde la solicitud POST
        $idMarca = $request->input('id_marca');

        // Consultar modelos filtrados por la marca_vehiculo_id
        $modelos = ModeloVehiculo::where('marca_vehiculo_id', $idMarca)->orderBy("nombre")->get();

        // Retornar los resultados en formato JSON
        return response()->json(['error' => false, 'modelos' => $modelos]);
    }

    public function CambiaEstadoMaterial(Request $request )
    {   
        $m = Materiales::find($request->input('material_id'));
        
        $estado = 0;
        $mensaje = 'Material desactivado con éxito.';

        if($request->input('activo_inactivo')){
            $estado = 1;
            $mensaje = 'Material activado con éxito.';
            
        }
        $m->estado = $estado;
        $m->save();
        return  redirect()->action([RepuestosController::class, 'Materiales'], ['bodega_id' => $request->input("bodega_id")])
                        ->with('success',$mensaje);
    }

    //INFORME DE VENTAS
    public function InformeVentas(Request $request){
        $argumentos = [
            "usuarios" => User::where("estado", "=", 1)->orderBy("nombre")->get(),
            "bodegas" => Bodega::where("estado", "=", 1)->orderBy("nombre")->get()
        ];

        return view("ventas.informe_ventas", $argumentos);
    }

    public function CargaInformeVentas(Request $request){
        // Obtener las fechas desde la solicitud
        $fechaInicio = $request->input('fechaInicio');
        $fechaFin = $request->input('fechaFin');
        $idUser = $request->input('usuario');
        $idBodega = $request->input('bodega');

        $fechaInicioFormatted = date('Y-m-d H:i:s', strtotime($fechaInicio));
        $fechaFinFormatted = date('Y-m-d H:i:s', strtotime($fechaFin));


        // Filtrar las ventas por las fechas
        $query = Ventas::whereBetween('created_at', [$fechaInicioFormatted, $fechaFinFormatted])
            ->where("estado", 1)
            ->orderBy("created_at", "desc");
            // ->get();
        
        if($idUser != "todos"){
            $query->where("vendendor_user_id", "=", $idUser);
        }

        if($idBodega != "todos"){
            $query->where("bodega_id", "=", $idBodega);
        }
        
        $ventas = $query->get();

        foreach($ventas as $v){
            $vendedor = User::find($v->vendendor_user_id);
            $v->nombre_vendendor = $vendedor->nombre . " " . $vendedor->apellido_paterno . " " . $vendedor->apellido_materno;
            $v->fecha = date("d-m-Y H:i:s", strtotime($v->created_at));

            $bodega = "";
            if(!is_null($v->bodega_id)){
                $b = Bodega::find($v->bodega_id);
                $bodega = $b->nombre;
            }
            $v->nombre_bodega = $bodega;
        }

        // Devolver los datos en formato JSON
        return response()->json(['ventas' => $ventas]);
    }

    public function VerDetalleVenta(Request $request){
        $idVenta = $request->input("id_venta");

        $venta = Ventas::find($idVenta);

        $detalle = MaterialesEntregados::where("venta_id", "=", $idVenta)->get();
        $total = 0;

        $descuento = $venta->descuento;
        $total_venta = $venta->total_venta;

        foreach($detalle as $d){
            $d->nombre_item = Materiales::find($d->material_id)->nombre;
            $total += ($d->cantidad * $d->valor);
        }

        return [
            "error" => false,
            "ventas" => $detalle,
            "subtotal" => $total,
            "descuento" => $descuento,
            "total" => $total_venta
        ];
    }

    public function InformeStock(Request $request)
    {
        // dd($id_bodega);
        // $materiales = Materiales::with('CategoriaMateriales')
        //     // ->where("estado", "=", 1)
        //     // ->where("bodega_id", "=", $bodega_id)
        //     ->orderBy('id','desc')
        //     ->get();
        // $empresas = Empresa::all();
        // $users = User::where("estado", "=", 1)->get();
        // $categorias = CategoriaMateriales::where("estado", "=", 1)->orderBy("nombre")->get();
        // $marcas = MarcaVehiculo::where("estado", "=", 1)->orderBy("nombre")->get();

        // Consulta para obtener los materiales con stock cero o stock igual/menor al stock crítico
        $materiales = Materiales::with('CategoriaMateriales')
            ->where('stock', 0)
            ->orWhereColumn('stock', '<=', 'stock_critico')
            ->get();
                
        return view('informe_stock',compact(
            'materiales',
            // 'users', 
            // 'categorias', 
            // 'bodega_id',
            // 'marcas'
        ));

    }
}