<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Auth;

use App\Models\Materiales;
use App\Models\Usuarios\User;
use App\Models\Usuarios\RolUser;
use App\Models\Empresa;
use App\Models\InformeCable;
use App\Models\MaterialesEntregados;
use App\Models\MaterialInformeCable;
use App\Models\DevolucionMateriales;
use App\Models\McenNotificacion;
use App\Models\UserNotificacion;


use App\Models\EvidenciaAntesDespues;
use App\Models\InformeSenialetica;
use App\Models\MaterialInformeSenialetica;

use App\Http\Traits\MetodosGlobales;

use PDF;


class InformeController extends Controller
{
    
    use MetodosGlobales;
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        if (view()->exists($request->path())) {
            return view('informes');
        }
        return abort(404);
    }

    public function reparacion_cables_mina(Request $request)
    {
        if (view()->exists($request->path())) {
            $materialescriticos = Materiales::all();
            $empresas = Empresa::orderBy('nombre')->get();
            return view('reparacion_cables_mina',compact('materialescriticos','empresas'));
        }
        return abort(404);
    }

    public function SelectUsuario(Request $request)
    {   
        $usuario = User::with('Empresa')->where('rut','=', str_replace('.', '', $request->input('rut_user')))->first();

        if(!$usuario){

            $retorno = 'No existe el Usuario';
        }else{

            $categoria_material_id  = $request->input('material_id');
            $sumMateriales = MaterialesEntregados::whereHas('Material', function($q) use ($categoria_material_id) {
                         
                        $q->when($categoria_material_id, function($q) use ($categoria_material_id) {

                              $q->where('categoria_material_id', $categoria_material_id);

                        });

                    })->groupBy('material_id')
                   ->selectRaw('material_id ,sum(cantidad) as sum')->where('user_recibe_id','=', $usuario->id )
                   ->get();
 

            $InformeCable = MaterialInformeCable::groupBy('material_id')
                                                            ->selectRaw('material_id ,sum(cantidad) as sum')
                                                            ->where('user_id','=', $usuario->id )->pluck('sum','material_id');

            $MaterialInformeSenialetica = MaterialInformeSenialetica::groupBy('material_id')
                                                            ->selectRaw('material_id ,sum(cantidad) as sum')
                                                            ->where('user_id','=', $usuario->id )->pluck('sum','material_id');
 
            $DevolucionMateriales =  DevolucionMateriales::groupBy('material_id')
                                                            ->selectRaw('material_id ,sum(cantidad) as sum')
                                                            ->where('user_entrega_id','=', $usuario->id )->pluck('sum','material_id');

            $totalMaterialesTrabajador = [];

            foreach ($sumMateriales as $key => $value) {

                $total_cantidad = 0;
                $total_cantidad_2 = 0;
                $total_cantidad_3 = 0; 

                $totalMaterialesTrabajador[$key]['cantidad'] = $value->sum;
                $totalMaterialesTrabajador[$key]['material'] = $value->Material->nombre;
                $totalMaterialesTrabajador[$key]['material_id'] = $value->Material->id;
                $totalMaterialesTrabajador[$key]['imagen'] = $value->Material->imagen;      

                if(array_key_exists($value->material_id,$InformeCable->toArray())){

                    $total_cantidad =  $InformeCable->toArray()[$value->material_id];
                    
                }
                if(array_key_exists($value->material_id, $DevolucionMateriales->toArray())){

                    $total_cantidad_2 =  $DevolucionMateriales->toArray()[$value->material_id];
                    
                }
                if(array_key_exists($value->material_id,$MaterialInformeSenialetica->toArray())){

                    $total_cantidad_3 =  $MaterialInformeSenialetica->toArray()[$value->material_id];
                    
                }

                if($total_cantidad + $total_cantidad_2 + $total_cantidad_3){

                    $totalMaterialesTrabajador[$key]['cantidad'] = $value->sum - ( $total_cantidad_2 + $total_cantidad + $total_cantidad_3);

                } 
                
                //    dd($totalMaterialesTrabajador);
            }

            $retorno = [$usuario , $totalMaterialesTrabajador];
        } 
 
        return  $retorno;
    }

    public function GuardaChecklistReparaCable(Request $request)
    {	   
        // dd($request->all());
        $retornomateriales = $request->input('material');
        $retornotecnico = $request->input('tecnico');

        $checklistreparacable = InformeCable::create($request->all());
 
        foreach ($request->input('material') as $key => $value) {
            MaterialInformeCable::create( [ 'informe_cable_id' => $checklistreparacable->id,                                          
                                            'cantidad' => $value['cantidad'],
                                            'material_id' => $key,
                                            'user_id' => $request->input('user_id')]  );
        }

        $checklistreparacable->load('User')->load('Empresa');

        $estadosUnidadesMedida = [
            1 => "MegaOhm",
            2 => "GigaOhm",
            3 => "TeraOhm",
            4 => "Falla"
        ];
     
        $archivoPDF = PDF::loadView('mails.reparacion_cables_pdf2', compact('checklistreparacable','retornomateriales','retornotecnico', 'estadosUnidadesMedida'))->setPaper('legal', 'portrait'); 
        //return view('mails.reparacion_cables_pdf2',   compact('checklistreparacable','retornomateriales','retornotecnico'));

        // para enviar email a los supervisores
        
		$id_empresa = User::where('id', $request->input('user_id') )->select('empresa_id')->first();
     
        // $RolesSupervisor = User::where('empresa_id', $id_empresa->empresa_id)->where("estado", "=", 1)->get();

        //busca a los supervisores de la empresa seleccionada
        $RolesSupervisor = User::join('rol_user', 'users.id', '=', 'rol_user.user_id')
            ->where('rol_user.rol_id', '=', 3)
            ->where('users.empresa_id', '=', $id_empresa->empresa_id)
            ->where('users.estado', '=', 1)
            ->select('users.*')
            ->get();

        // $users_notify = UserNotificacion::where('id_categoria_material', 1)->get();
        // dd($RolesSupervisor);

        //busca supervisores de la misma empresa de la persona que creo el informe
        if($RolesSupervisor->count()){
            foreach ($RolesSupervisor as $key => $value) {
                // foreach ($users_notify as $user_noti) {
                    // if($value->id == $user_noti->id_user){
                        $this->enviaEmail(
                            'mails.email_base', 
                            [ 
                                'checklistreparacable' => $checklistreparacable , 
                                'retornomateriales' =>  $retornomateriales , 
                                'tipo' =>  'Reparacion de cables' 
                            ] ,  
                            $value->email , 
                            'Reporte cables supervisores', 
                            $archivoPDF 
                        );
                    // }
                // }


            }
        }

        //envia correo a creador de informe
        $this->enviaEmail(
            'mails.email_base', 
            [ 
                'checklistreparacable' => $checklistreparacable , 
                'retornomateriales' =>  $retornomateriales , 
                'tipo' =>  'Reparacion de cables'  
            ], 
            $request->input('email_entrega'), 
            'Reporte cables', 
            $archivoPDF 
        );
        
        return  redirect()->action([InformeController::class, 'reparacion_cables_mina'])
                    ->with('success','Reporte realizado con éxito');
 
    }

    public function InformeSenialetica(Request $request)
    {
        if (view()->exists($request->path())) {
            // $materiales = Materiales::orderBy('id','desc')->get();
            // $empresas = Empresa::all();
            // $users = User::all();
            return view('senialetica');
        }
        return abort(404);

    }



    public function GuardaSenialetica(Request $request)
    {

        $InformeSenialetica = InformeSenialetica::create($request->all());
        $retornomateriales = $request->input('material');
        $retornotecnico = $request->input('tecnico');
        $evidencia_antes_despues = [];

        foreach ($request->input('material') as $key => $value) {

            MaterialInformeSenialetica::create( [ 'informe_senialetica_id' => $InformeSenialetica->id,                                          
                                            'cantidad' => $value['cantidad'],
                                            'material_id' => $key,
                                            'user_id' => $request->input('user_id')]  );
        }

        $ruta_img = 'app/assets/images/senialetica/images';
        $ruta_thumbnail = 'app/assets/images/senialetica/thumbnail';
 
        foreach ($request->all()['evidencia_antes_despues'] as $key => $value) {

                $nombre_archivo1 =  $this->guardaImagen($value["imagen_antes"],  $ruta_img , $ruta_thumbnail);            
                $nombre_archivo2 =  $this->guardaImagen($value["imagen_despues"] ,  $ruta_img , $ruta_thumbnail);

            EvidenciaAntesDespues::create( [ 'informe_senialetica_id' => $InformeSenialetica->id,                                          
                                            'impit_expit' => $value['impit_expit'],
                                            'descripcion_ubicacion' => $value['descripcion_ubicacion'],
                                            'imagen_antes' => $nombre_archivo1,
                                            'imagen_despues' => $nombre_archivo2 ]  );

            $evidencia_antes_despues[$key]['impit_expit'] = $value['impit_expit'];
            $evidencia_antes_despues[$key]['imagen_antes'] =  $nombre_archivo1;
            $evidencia_antes_despues[$key]['imagen_despues'] = $nombre_archivo2;
            $evidencia_antes_despues[$key]['descripcion_ubicacion'] = $value['descripcion_ubicacion'];

        }
 
        $InformeSenialetica->load('User')->load('Empresa');

        // User::whereHas('RolesSupervisor')->where('empresa_id',$request->input('empresa_id'))->get();
     
        $archivoPDF = PDF::loadView('mails.senialetica_pdf2', compact('InformeSenialetica','retornomateriales','evidencia_antes_despues','retornotecnico'))->setPaper('legal', 'portrait'); 
     //  return view('mails.senialetica_pdf2',  compact('InformeSenialetica','retornomateriales','evidencia_antes_despues','retornotecnico'));
        
     $this->enviaEmail('mails.email_base', [ 'senialetica' => $InformeSenialetica , 'retornomateriales' =>  $retornomateriales, 'tipo' =>  'Señaletica' ] ,$retornotecnico['email_tecnico'] , 'Reporte señaletica', $archivoPDF );


        // para enviar email a los supervisores
		$id_empresa = User::where('id', $request->input('user_id') )->select('empresa_id')->first();

        //// $RolesSupervisor = User::whereHas('RolesSupervisor')->where( 'empresa_id', $id_empresa->empresa_id )->get();
        // $RolesSupervisor = User::where('empresa_id', $id_empresa->empresa_id)->where("estado", "=", 1)->get();
        // $users_notify = UserNotificacion::where('id_categoria_material', 2)->get();

        $RolesSupervisor = User::join('rol_user', 'users.id', '=', 'rol_user.user_id')
            ->where('rol_user.rol_id', '=', 3)
            ->where('users.empresa_id', '=', $id_empresa->empresa_id)
            ->where('users.estado', '=', 1)
            ->select('users.*')
            ->get();

        if($RolesSupervisor->count()){ 
            foreach ($RolesSupervisor as $key => $value) {

                $this->enviaEmail(
                    'mails.email_base', 
                    [ 
                        'senialetica' => $InformeSenialetica , 
                        'retornomateriales' =>  $retornomateriales, 
                        'tipo' =>  'Señaletica' 
                    ] , 
                    $value->email , 
                    'Reporte cables supervisores', 
                    $archivoPDF 
                );

            }
        }

        
        return  redirect()->action([InformeController::class, 'InformeSenialetica'])
                    ->with('success','Reporte senialetica realizado con éxito');
 
    }

    public function NotifyCentinela(Request $request, $id_informe)
    {
        // dd($id_informe);
        $retornotecnico = [ "nom_tecnico" => $request->input('nom_tecnico'),
                            "rut_tecnico" => $request->input('rut_tecnico'),
                            "nom_empresa" => $request->input('empresa_tecnico'),
                            "email_tecnico" => $request->input('email_tecnico')
                           ]; 
        
        if($request->input('tipo') == 'senialetica'){
            $InformeSenialetica = InformeSenialetica::where('id', $id_informe)->first();
            $MaterialInformeSenialetica = MaterialInformeSenialetica::where('informe_senialetica_id','=', $InformeSenialetica->id )->pluck('material_id');
            $retornomateriales = Materiales::whereIn('id',$MaterialInformeSenialetica->toArray())->get();
            $evidencia_antes_despues = EvidenciaAntesDespues::where('informe_senialetica_id' , $InformeSenialetica->id )->get();     

            // $users = User::where('empresa_id', $InformeSenialetica->empresa_id)->get();
            // $users_notify = UserNotificacion::where('id_categoria_material', 2)->get();
            // $users_centinela = McenNotificacion::all();
            $users_notify = UserNotificacion::where('id_categoria_material', 2)->where('estado', '=', 1)->pluck('id_user');
            $listaUsers = User::whereIn('id', $users_notify)->get();

            $archivoPDF = PDF::loadView('mails.senialetica_pdf2', compact('InformeSenialetica','retornomateriales','evidencia_antes_despues','retornotecnico'))->setPaper('legal', 'portrait'); 
            
            // if($users_centinela){
                // foreach ($users_centinela as $key => $value) {
                    foreach($listaUsers as $us_noti){
                        // if ($value->id_user == $us_noti->id_user && $value->info_user->empresa_id == 169) {
                            // dd($us_noti->info_user->email);
                            $this->enviaEmail(
                                'mails.email_base', 
                                [ 
                                    'senialetica' => $InformeSenialetica , 
                                    'retornomateriales' =>  $retornomateriales, 
                                    'tipo' =>  'Señaletica' 
                                ] , 
                                $us_noti->email , 
                                'Reporte Informe de Señaletica para MCEN', 
                                $archivoPDF 
                            );
                        // }
                    }
                // }
            // }
            $argumentos = [
                "tipo_informe" => $request->input('tipo'),
                "trabajador" => $request->input('rut_tecnico'),
                "fecha_inicio" => $request->input('fecha_inicio'),
                "fecha_fin" => $request->input('fecha_fin')
            ];
            
            return  redirect()->action([BuscaInformesController::class, 'ResultadoBuscaInformes'], $argumentos)->with('success','Notificaciones a Centinela Enviadas');
                
        }else{

            $checklistreparacable = InformeCable::where('id', $id_informe)->first();
            $MaterialInformeCable = MaterialInformeCable::where('informe_cable_id','=', $checklistreparacable->id )->pluck('material_id');
            $retornomateriales = Materiales::whereIn('id',$MaterialInformeCable->toArray())->get();
            
            // $users = User::where('empresa_id', $InformeSenialetica->empresa_id)->get();
            $users_notify = UserNotificacion::where('id_categoria_material', 1)->where('estado', '=', 1)->pluck('id_user');
            // $users_centinela = McenNotificacion::all();

            $listaUsers = User::whereIn('id', $users_notify)->get();
            
            $estadosUnidadesMedida = [
                1 => "MegaOhm",
                2 => "GigaOhm",
                3 => "TeraOhm",
                4 => "Falla"
            ];
            
            $archivoPDF = PDF::loadView(
                    'mails.reparacion_cables_pdf2', 
                    compact('checklistreparacable','retornomateriales','retornotecnico', 'estadosUnidadesMedida')
                )->setPaper('legal', 'portrait'); 
            
            // if($users_centinela){
                // foreach ($users_centinela as $key => $value) {
                    foreach($listaUsers as $us_noti){
                        // if ($value->id_user == $us_noti->id_user && $value->info_user->empresa_id == 169) {
                            // dd($us_noti->info_user->email);
                            // $this->enviaEmail('mails.email_base', [ 'senialetica' => $InformeSenialetica , 'retornomateriales' =>  $retornomateriales, 'tipo' =>  'Señaletica' ] , $us_noti->info_user->email , 'Reporte cables supervisores', $archivoPDF );
                        // }
                        $this->enviaEmail(
                            'mails.email_base', 
                            [ 
                                'checklistreparacable' => $checklistreparacable , 
                                'retornomateriales' =>  $retornomateriales , 
                                'tipo' =>  'Reparacion de cables' 
                            ] ,  
                            $us_noti->email , 
                            'Reporte de Informe de Cables para MCEN', 
                            $archivoPDF 
                        );
                    }
                // }
            // }
            // $RolesSupervisor2 = ['jlopezv@mineracentinela.cl','flopez@mineracentinela.cl','haravena@mineracentinela.cl','rguzman@mineracentinela.cl','rjimenezb@mineracentinela.cl','rmoram@mineracentinela.cl','adcsyc@arayabriones.cl','juan.pizarro@arayabriones.cl','rojorquera@mineracentinela.cl'];

            $argumentos = [
                "tipo_informe" => $request->input('tipo'),
                "trabajador" => $request->input('rut_tecnico'),
                "fecha_inicio" => $request->input('fecha_inicio'),
                "fecha_fin" => $request->input('fecha_fin')
            ];
            
            return  redirect()->action([BuscaInformesController::class, 'ResultadoBuscaInformes'], $argumentos)->with('success','Notificaciones a Centinela Enviadas');
        }

 
    }

 
}
