<?php

namespace App\Http\Controllers\Bodegas;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;

// use App\Models\Usuarios\Rol;
// use App\Models\Empresa;
// use App\Models\Usuarios\User;
// use App\Models\CategoriaMateriales;
// use App\Models\UserNotificacion;

use App\Http\Traits\MetodosGlobales;
use App\Models\Bodega;

class BodegasController extends Controller
{
    
    use MetodosGlobales;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bodegas = Bodega::orderBy("nombre")->get();

        $datos = [
            "bodegas" => $bodegas

        ];

        return view('bodegas.index', $datos);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    // public function create()
    // {
    //     return view('turnos.create');
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $request->validate([
            'nombre' => 'required',
            // 'email' => 'required',
        ]);
 
        // $email = $request->input("email"); 
        // $clave = $request->input("password"); 
        // $this->enviaEmail('mails.nuevo_usuario_email', ['email'=> $email ,'clave' => $clave ] , $request->input("email") , 'Datos Nuevo Usuario Gestion Jc', '');
 
        // $request->request->add(['password' => Hash::make($request->input("password"))]); 
        $nuevo_usuario = Bodega::create($request->all());

        // $input = $request->all();
        // $id_categorias = $input['id_categoria'];
        // $user_created = User::where('email', $email)->first();
        // foreach($id_categorias as $id_categoria){
        //     $newuser_not = new UserNotificacion();
        //     $newuser_not->id_user = $nuevo_usuario->id;
        //     $newuser_not->id_categoria_material= $id_categoria;
        //     $newuser_not->estado = 1;
        //     $newuser_not->save();
            
        // }

        // $nuevo_usuario->roles()->sync([$request->input("rol_id")]);

        return  redirect()->action([BodegasController::class, 'index'])
                        ->with('success','Bodega creada con éxito.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function show(User $user)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    // public function edit(User $user)
    // {
    //     //
    // }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Bodega $b)
    {   
        // dd($request->all());

        $request->validate([
            'nombre' => 'required',
            // 'email' => 'required',
        ]);

        $bodega = Bodega::find($request->input("bodega_id"));

        $bodega->nombre = $request->input("nombre");
        $bodega->save();
      
        // if( $request->input("password")  || ( $user->email != $request->input('email')  ) ){

        //     $email = $request->input("email"); 
        //     $clave = $request->input("password");
        //     $this->enviaEmail('mails.nuevo_usuario_email', ['email'=> $email ,'clave' => $clave ] , $request->input("email")  , 'Datos Usuario Gestion Jc', '');
        // }


        // $arr_update = $request->all();
        
        // if(is_null( $request->input('password') ) ){

        //     unset($arr_update['password']);

        // }else{

        //     $arr_update['password'] = Hash::make($request->input("password")); 
        // }

        // $b->update($arr_update);
        // $user->roles()->sync($request->input('rol_id'));

        // $input = $request->all();
        // $id_categorias = $input['id_categoria'];
        // $user_created = User::where('email', $input['email'])->first();
        // $user_notification = UserNotificacion::where('id_user',$user_created->id)->get();
       
        // if($user_notification){
        //     foreach ($user_notification as $key) {
        //         // dd($key->id);
        //         $user = UserNotificacion::find($key->id);
        //         $user->delete();
        //     }

        //     foreach($id_categorias as $id_categoria){
        //         $newuser_not = new UserNotificacion();
        //         $newuser_not->id_user = $user_created->id;
        //         $newuser_not->id_categoria_material= $id_categoria;
        //         $newuser_not->estado = 1;
        //         $newuser_not->save();
                
        //     }
        // }
    
        return  redirect()->action([BodegasController::class, 'index'])
                        ->with('success','Bodega editada con éxito.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Usuarios\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Bodega $b)
    {   
        // dd($request->all());
        $estado = 0;
        $bodega = Bodega::find($request->input("bodega_id"));


        if($request->input('activo_inactivo')){
            $estado = 1;
        }
        $bodega->estado = $estado;
        $bodega->save();

        return  redirect()->action([BodegasController::class, 'index'])
                        ->with('success','Bodega desactivada con éxito.');
    }

    // public function creaUsuario(Request $request)
    // {
    //     $request->request->add(['password' => Hash::make($request->input("rut"))]); 
    //     $usuario = User::create($request->all());
    //     $usuario->roles()->sync([4]);
    //     return  collect([ $usuario->load('Empresa')]);
    // }


}
