<?php

namespace App\Console\Commands;

use App\Mail\EnvioEmailInforme;
use Illuminate\Console\Command;

use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;

class EnviaEmailInformeQuiebreStock extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'emails:quiebre-stock';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envia informe de quiebre de stock de productos';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Consulta SQL a la vista "datos"
        $dataFromSQLView = DB::select('SELECT * FROM informe_quiebre_stock');

        // Generar el archivo Excel en memoria
        $excelFileName = 'data_' . now()->format('Y-m-d') . '.xlsx';
        // $filePath = storage_path('app/' . $excelFileName);
        // $excel = Excel::raw(new class($dataFromSQLView) implements FromCollection {
        //     private $data;

        //     public function __construct($data)
        //     {
        //         $this->data = $data;
        //     }

        //     public function collection()
        //     {
        //         return collect($this->data);
        //     }
        // }, 'Xlsx');
        $headers = !empty($dataFromSQLView) ? array_keys((array) $dataFromSQLView[0]) : [];

        $excel = Excel::raw(new class($dataFromSQLView, $headers) implements FromCollection {
            private $data;
            private $headers;

            public function __construct($data, $headers)
            {
                $this->data = $data;
                $this->headers = $headers;
            }

            public function collection()
            {
                $collection = collect([$this->headers]);
                foreach ($this->data as $row) {
                    // Reemplazar valores nulos o 0 por "0" para mostrar en el Excel
                    $formattedRow = array_map(function ($value) {
                        return ($value === null || $value === 0) ? "0" : $value;
                    }, (array) $row);
                    $collection->push($formattedRow);
                }
                return $collection;
            }
        }, 'Xlsx');

        $customMessage = "Se envía Informe de Quiebre de Stock.";

        // Obtener destinatarios del archivo .env
        $recipients = explode(',', env('DESTINATARIOS_INFORME_QUIEBRE_STOCK'));

        // Enviar correos a los destinatarios
        foreach ($recipients as $recipient) {
            Mail::to($recipient)->send(new EnvioEmailInforme($excel, $customMessage));
        }

    }
}
